/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.system.common.query.AbstractArchetypeQuery;
import org.openvpms.component.system.common.query.ArchetypeQueryException;
import org.openvpms.component.system.common.query.IArchetypeQuery;

public abstract class IterableQuery<T>
implements Iterable<T> {
    private final IArchetypeService service;
    private final AbstractArchetypeQuery query;
    private boolean first = true;
    private final int firstResult;

    public IterableQuery(IArchetypeService service, AbstractArchetypeQuery query) {
        this.query = query;
        this.firstResult = query.getFirstResult();
        this.service = service;
    }

    protected IArchetypeService getArchetypeService() {
        return this.service;
    }

    protected IArchetypeQuery getQuery() {
        AbstractArchetypeQuery result;
        try {
            if (this.first) {
                result = this.query;
                this.first = false;
            } else {
                result = (AbstractArchetypeQuery)this.query.clone();
                result.setFirstResult(this.firstResult);
            }
        }
        catch (CloneNotSupportedException exception) {
            throw new ArchetypeQueryException(ArchetypeQueryException.ErrorCode.CloneNotSupported, exception, this.query);
        }
        return result;
    }
}

