/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.singleton;

import java.util.function.Consumer;
import org.openvpms.component.business.service.singleton.SingletonQuery;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SingletonServiceImpl
implements SingletonService {
    private final ArchetypeService service;
    private final SingletonQuery query;
    private final PlatformTransactionManager transactionManager;

    public SingletonServiceImpl(ArchetypeService service, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.transactionManager = transactionManager;
        this.query = new SingletonQuery(service);
    }

    @Override
    public boolean exists(String archetype) {
        return this.query.exists(archetype);
    }

    @Override
    public boolean exists(String archetype, Reference exclude) {
        return this.query.exists(archetype, exclude);
    }

    @Override
    public <T extends IMObject> T get(String archetype, Class<T> type) {
        return this.query.get(archetype, type);
    }

    @Override
    public <T extends IMObject> T get(String archetype, Class<T> type, boolean create) {
        T result = create ? this.getOrCreate(archetype, type, null) : this.get(archetype, type);
        return result;
    }

    @Override
    public <T extends IMObject> T get(String archetype, Class<T> type, Consumer<T> populator) {
        return this.getOrCreate(archetype, type, populator);
    }

    private <T extends IMObject> T getOrCreate(String archetype, Class<T> type, Consumer<T> populator) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        return (T)((IMObject)template.execute(status -> {
            Object object = this.get(archetype, type);
            if (object == null) {
                object = this.service.create(archetype, type);
                if (populator != null) {
                    populator.accept(object);
                }
                this.service.save(object);
            }
            return object;
        }));
    }
}

