/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.cache;

import org.ehcache.Cache;
import org.ehcache.core.spi.service.StatisticsService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.cache.AbstractEhcacheManager;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

public class ConfigurableEhcacheManager
extends AbstractEhcacheManager {
    private final IArchetypeService service;
    private final String archetype;

    public ConfigurableEhcacheManager(IArchetypeService service, String archetype) {
        this(null, service, archetype);
    }

    public ConfigurableEhcacheManager(StatisticsService statistics, IArchetypeService service, String archetype) {
        super(statistics);
        this.service = service;
        this.archetype = archetype;
    }

    @Override
    public <K, V> void setMaxElements(Cache<K, V> cache, String name, long maxElements) {
        super.setMaxElements(cache, name, maxElements);
        IMObjectBean config = this.getConfig();
        String node = this.getMaxElementsNode(name);
        if (config != null && config.hasNode(node)) {
            config.setValue(node, (Object)maxElements);
            config.save();
        }
    }

    @Override
    protected long getMaxElements(String name) {
        Object value;
        long result = -1L;
        IMObjectBean config = this.getConfig();
        String node = this.getMaxElementsNode(name);
        if (config != null && config.hasNode(node) && (result = config.getLong(node)) == 0L && (value = config.getDefaultValue(node)) instanceof Number) {
            result = ((Number)value).longValue();
        }
        return result;
    }

    private String getMaxElementsNode(String name) {
        return name + "MaxElements";
    }

    private IMObjectBean getConfig() {
        ArchetypeQuery query = new ArchetypeQuery(this.archetype, true, true);
        query.add(Constraints.sort("id"));
        query.setMaxResults(1);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, query);
        return iterator.hasNext() ? this.service.getBean((IMObject)iterator.next()) : null;
    }
}

