/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.audit;

import java.util.Date;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.openvpms.component.business.dao.im.audit.IAuditDAO;
import org.openvpms.component.business.domain.im.audit.AuditRecord;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.audit.AuditServiceException;
import org.openvpms.component.business.service.audit.IAuditService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditService
implements MethodInterceptor,
IAuditService {
    private static final Logger logger = LoggerFactory.getLogger(AuditService.class);
    private IAuditDAO dao;

    public AuditService(IAuditDAO dao) {
        this.dao = dao;
    }

    public IAuditDAO getDao() {
        return this.dao;
    }

    public void setDao(IAuditDAO dao) {
        this.dao = dao;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object rval = invocation.proceed();
        this.afterMethodInvocation(invocation);
        return rval;
    }

    @Override
    public AuditRecord getById(long id) {
        try {
            return this.dao.getById(id);
        }
        catch (Exception exception) {
            throw new AuditServiceException(AuditServiceException.ErrorCode.FailedToGetById, new Object[]{id}, exception);
        }
    }

    @Override
    public List<AuditRecord> getByObjectId(String archetypeId, long id) {
        try {
            return this.dao.getByObjectId(archetypeId, id);
        }
        catch (Exception exception) {
            throw new AuditServiceException(AuditServiceException.ErrorCode.FailedToGetByObjectId, new Object[]{archetypeId, id}, exception);
        }
    }

    private void afterMethodInvocation(MethodInvocation invocation) {
        if (invocation.getArguments()[0] instanceof IMObject) {
            IMObject imObject = (IMObject)invocation.getArguments()[0];
            try {
                AuditRecord audit = new AuditRecord();
                audit.setArchetypeId(imObject.getArchetypeIdAsString());
                audit.setObjectId(imObject.getId());
                audit.setOperation(invocation.getMethod().getName());
                audit.setService(invocation.getThis().getClass().getName());
                audit.setUser("unknown");
                audit.setTimeStamp(new Date());
                this.dao.insert(audit);
            }
            catch (Exception exception) {
                logger.error("Error in AuditService.afterMethodInvocation: {}", (Object)exception.getMessage(), (Object)exception);
            }
        }
    }
}

