/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import org.apache.commons.jxpath.Variables;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.business.service.archetype.helper.PropertyResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolverException;
import org.openvpms.component.business.service.archetype.helper.PropertySetResolver;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.MapPropertySet;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.component.system.common.util.PropertyState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMObjectVariables
implements org.openvpms.component.system.common.util.Variables,
Variables {
    private final transient ArchetypeService service;
    private final transient LookupService lookups;
    private final transient PropertySet variables = new MapPropertySet();
    private transient PropertyResolver resolver;
    private static final Logger log = LoggerFactory.getLogger(IMObjectVariables.class);

    public IMObjectVariables(ArchetypeService service, LookupService lookups) {
        this.service = service;
        this.lookups = lookups;
    }

    public void add(String name, Object value) {
        this.variables.set(name, value);
    }

    @Override
    public Object get(String name) {
        Object result = null;
        try {
            result = this.getResolver().getObject(name);
        }
        catch (PropertyResolverException exception) {
            log.debug("Variable not found: " + name, (Throwable)((Object)exception));
        }
        return result;
    }

    @Override
    public boolean exists(String name) {
        boolean result = false;
        try {
            this.getResolver().getObject(name);
            result = true;
        }
        catch (PropertyResolverException exception) {
            log.debug("Variable not found: " + name, (Throwable)((Object)exception));
        }
        return result;
    }

    public void declareVariable(String varName, Object value) {
        this.add(varName, value);
    }

    public void undeclareVariable(String varName) {
        throw new UnsupportedOperationException("undeclareVariable() is not supported by IMObjectVariables");
    }

    public Object getVariable(String varName) {
        try {
            return this.getResolver().getObject(varName);
        }
        catch (PropertyResolverException exception) {
            throw new IllegalArgumentException("Variable " + varName + " not found");
        }
    }

    public boolean isDeclaredVariable(String varName) {
        return this.exists(varName);
    }

    protected PropertyResolver createResolver(PropertySet variables, ArchetypeService service, LookupService lookups) {
        this.resolver = new PropertySetResolver(variables, service, lookups){

            @Override
            public Object getObject(String name) {
                return IMObjectVariables.this.getValue(this.resolve(name));
            }
        };
        return this.resolver;
    }

    protected Object getValue(PropertyState state) {
        NodeDescriptor descriptor = state.getNode();
        Object value = descriptor != null && descriptor.isLookup() ? LookupHelper.getName(this.service, this.lookups, descriptor, state.getParent()) : state.getValue();
        return value;
    }

    protected PropertyResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = this.createResolver(this.variables, this.service, this.lookups);
        }
        return this.resolver;
    }
}

