/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.helper.BasePropertyResolver;
import org.openvpms.component.business.service.archetype.helper.NodeResolver;
import org.openvpms.component.business.service.archetype.helper.PropertyResolverException;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.PropertyState;

public abstract class AbstractPropertyResolver
extends BasePropertyResolver {
    protected AbstractPropertyResolver(ArchetypeService service, LookupService lookups) {
        super(service, lookups);
    }

    @Override
    public Object getObject(String name) {
        return this.resolve(name).getValue();
    }

    @Override
    public List<Object> getObjects(String name) {
        List<Object> result;
        Root root = this.getRoot(name);
        if (StringUtils.isEmpty((CharSequence)(name = root.nodeName))) {
            result = new ArrayList<Object>();
            if (root.object != null) {
                result.add(root.object);
            }
        } else if (root.object instanceof IMObject) {
            result = this.getObjects((IMObject)root.object, name);
        } else {
            throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidProperty, name);
        }
        return result;
    }

    @Override
    public PropertyState resolve(String name) {
        PropertyState result = null;
        Root root = this.getRoot(name);
        Object object = root.object;
        String nodeName = root.nodeName;
        if (object instanceof IMObject && !StringUtils.isEmpty((CharSequence)nodeName)) {
            result = this.resolve((IMObject)object, nodeName);
        }
        if (result == null) {
            result = new PropertyState(name, object);
        }
        return result;
    }

    protected PropertyState resolve(IMObject object, String name) {
        NodeResolver resolver = new NodeResolver(object, this.getService(), this.getLookups());
        return resolver.resolve(name);
    }

    protected abstract Object get(String var1);

    protected abstract boolean exists(String var1);

    private Root getRoot(String name) {
        int index = 0;
        String objectName = name;
        String nodeName = "";
        Object object = null;
        while (index != -1) {
            if (this.exists(objectName)) {
                object = this.get(objectName);
                if (!(object instanceof IMObjectReference)) break;
                object = this.resolve((IMObjectReference)object);
                break;
            }
            if ((index = name.indexOf(46, index)) == -1) continue;
            objectName = name.substring(0, index);
            nodeName = name.substring(index + 1);
            ++index;
        }
        if (index == -1) {
            throw new PropertyResolverException(PropertyResolverException.ErrorCode.InvalidObject, name);
        }
        return new Root(object, nodeName);
    }

    private static class Root {
        private final Object object;
        private final String nodeName;

        public Root(Object object, String nodeName) {
            this.object = object;
            this.nodeName = nodeName;
        }
    }
}

