/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.descriptor.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionTypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.descriptor.cache.ArchetypeDescriptorCacheException;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.system.common.util.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseArchetypeDescriptorCache
implements IArchetypeDescriptorCache {
    private final Map<String, ArchetypeDescriptor> archetypesByShortName = Collections.synchronizedMap(new HashMap());
    private final Map<String, ArchetypeDescriptor> archetypesById = Collections.synchronizedMap(new HashMap());
    private final Map<String, AssertionTypeDescriptor> assertionTypes = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<String>> wildcardCache = new HashMap<String, List<String>>();
    private static final Logger log = LoggerFactory.getLogger(BaseArchetypeDescriptorCache.class);

    protected BaseArchetypeDescriptorCache() {
    }

    @Override
    public ArchetypeDescriptor getArchetypeDescriptor(String name) {
        return this.archetypesByShortName.get(name);
    }

    @Override
    public ArchetypeDescriptor getArchetypeDescriptor(ArchetypeId id) {
        ArchetypeDescriptor result = this.archetypesById.get(id.getQualifiedName());
        if (result == null && id.getVersion() == null) {
            result = this.getArchetypeDescriptor(id.getShortName());
        }
        return result;
    }

    @Override
    public List<ArchetypeDescriptor> getArchetypeDescriptors() {
        return new ArrayList<ArchetypeDescriptor>(this.archetypesById.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArchetypeDescriptor> getArchetypeDescriptors(String shortName) {
        ArrayList<ArchetypeDescriptor> descriptors = new ArrayList<ArchetypeDescriptor>();
        Map<String, ArchetypeDescriptor> map = this.archetypesByShortName;
        synchronized (map) {
            for (Map.Entry<String, ArchetypeDescriptor> entry : this.archetypesByShortName.entrySet()) {
                if (!TypeHelper.matches(entry.getKey(), shortName)) continue;
                descriptors.add(entry.getValue());
            }
        }
        return descriptors;
    }

    @Override
    public AssertionTypeDescriptor getAssertionTypeDescriptor(String name) {
        return this.assertionTypes.get(name);
    }

    @Override
    public List<AssertionTypeDescriptor> getAssertionTypeDescriptors() {
        return new ArrayList<AssertionTypeDescriptor>(this.assertionTypes.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getArchetypeShortNames(String entityName, String conceptName, boolean primaryOnly) {
        ArrayList<String> shortNames = new ArrayList<String>();
        Map<String, ArchetypeDescriptor> map = this.archetypesByShortName;
        synchronized (map) {
            for (ArchetypeDescriptor desc : this.archetypesByShortName.values()) {
                ArchetypeId archId = desc.getType();
                if (!StringUtils.isEmpty((CharSequence)entityName) && !StringUtilities.matches(archId.getEntityName(), entityName) || !StringUtils.isEmpty((CharSequence)conceptName) && !StringUtilities.matches(archId.getConcept(), conceptName) || primaryOnly && !desc.isPrimary()) continue;
                shortNames.add(archId.getShortName());
            }
        }
        return shortNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getArchetypeShortNames(String shortName, boolean primaryOnly) {
        ArrayList<String> result;
        Map<String, ArchetypeDescriptor> map = this.archetypesByShortName;
        synchronized (map) {
            String key = shortName + ":" + primaryOnly;
            List<String> archetypes = this.wildcardCache.get(key);
            if (archetypes == null) {
                archetypes = new ArrayList<String>();
                for (Map.Entry<String, ArchetypeDescriptor> entry : this.archetypesByShortName.entrySet()) {
                    String archetype = entry.getKey();
                    if (!TypeHelper.matches(archetype, shortName) || primaryOnly && !entry.getValue().isPrimary()) continue;
                    archetypes.add(archetype);
                }
                this.wildcardCache.put(key, archetypes);
            }
            result = new ArrayList<String>(archetypes);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addArchetypeDescriptor(ArchetypeDescriptor descriptor) {
        ArchetypeId archId = descriptor.getType();
        Map<String, ArchetypeDescriptor> map = this.archetypesByShortName;
        synchronized (map) {
            if (descriptor.isLatest() || !this.archetypesByShortName.containsKey(archId.getShortName())) {
                this.archetypesByShortName.put(archId.getShortName(), descriptor);
            }
            this.wildcardCache.clear();
        }
        this.archetypesById.put(archId.getQualifiedName(), descriptor);
    }

    @Override
    public void addAssertionTypeDescriptor(AssertionTypeDescriptor descriptor) {
        this.assertionTypes.put(descriptor.getName(), descriptor);
    }

    @Override
    public List<String> getArchetypeShortNames() {
        return new ArrayList<String>(this.archetypesByShortName.keySet());
    }

    protected void checkAssertionsInNode(Map<String, NodeDescriptor> nodes) {
        for (NodeDescriptor node : nodes.values()) {
            for (AssertionDescriptor assertion : node.getAssertionDescriptorsAsArray()) {
                this.processAssertion(assertion);
            }
            if (node.getNodeDescriptors().isEmpty()) continue;
            this.checkAssertionsInNode(node.getNodeDescriptors());
        }
    }

    protected void processAssertion(AssertionDescriptor assertion) {
        AssertionTypeDescriptor descriptor = this.assertionTypes.get(assertion.getName());
        if (descriptor == null) {
            log.warn("Attempting to find {} in [{}]", (Object)assertion.getName(), this.assertionTypes);
            throw new ArchetypeDescriptorCacheException(ArchetypeDescriptorCacheException.ErrorCode.InvalidAssertionSpecified, new Object[]{assertion.getName()});
        }
        assertion.setDescriptor(descriptor);
    }
}

