/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.common;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openvpms.component.business.domain.im.common.AuditableIMObject;
import org.openvpms.component.business.domain.im.common.EntityException;
import org.openvpms.component.business.domain.im.common.EntityIdentity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;

public class Entity
extends AuditableIMObject
implements org.openvpms.component.model.entity.Entity {
    private Set<Lookup> classifications = new HashSet<Lookup>();
    private Set<org.openvpms.component.model.entity.EntityIdentity> identities = new HashSet<org.openvpms.component.model.entity.EntityIdentity>();
    private Set<EntityRelationship> sourceEntityRelationships = new HashSet<EntityRelationship>();
    private Set<EntityRelationship> targetEntityRelationships = new HashSet<EntityRelationship>();
    private Set<EntityLink> entityLinks = new HashSet<EntityLink>();
    private static final long serialVersionUID = 3L;

    public void addIdentity(org.openvpms.component.model.entity.EntityIdentity identity) {
        ((EntityIdentity)identity).setEntity(this);
        this.identities.add(identity);
    }

    public boolean removeIdentity(org.openvpms.component.model.entity.EntityIdentity identity) {
        ((EntityIdentity)identity).setEntity(null);
        return this.identities.remove(identity);
    }

    public Set<org.openvpms.component.model.entity.EntityIdentity> getIdentities() {
        return this.identities;
    }

    public Set<org.openvpms.component.model.entity.EntityIdentity> getIdentities(String archetype) {
        return this.getIdentities().stream().filter(identity -> identity.isA(archetype)).collect(Collectors.toSet());
    }

    public org.openvpms.component.model.entity.EntityIdentity getIdentity(String archetype) {
        return this.getIdentities(archetype).stream().min(Comparator.comparingLong(IMObject::getId)).orElse(null);
    }

    public String getIdentifier(String archetype) {
        org.openvpms.component.model.entity.EntityIdentity identity = this.getIdentity(archetype);
        return identity != null ? identity.getIdentity() : null;
    }

    public Set<EntityRelationship> getSourceEntityRelationships() {
        return this.sourceEntityRelationships;
    }

    public Set<EntityRelationship> getTargetEntityRelationships() {
        return this.targetEntityRelationships;
    }

    public void addEntityRelationship(EntityRelationship relationship) {
        if (relationship.getSource() == null || relationship.getTarget() == null) {
            throw new EntityException(EntityException.ErrorCode.FailedToAddEntityRelationship, new Object[]{relationship.getSource(), relationship.getTarget()});
        }
        if (Objects.equals(relationship.getSource().getLinkId(), this.getLinkId()) && Objects.equals(relationship.getSource().getArchetype(), this.getArchetype())) {
            this.sourceEntityRelationships.add(relationship);
        } else if (Objects.equals(relationship.getTarget().getLinkId(), this.getLinkId()) && Objects.equals(relationship.getTarget().getArchetype(), this.getArchetype())) {
            this.targetEntityRelationships.add(relationship);
        } else {
            throw new EntityException(EntityException.ErrorCode.FailedToAddEntityRelationship, new Object[]{relationship.getSource(), relationship.getTarget()});
        }
    }

    public void removeEntityRelationship(EntityRelationship relationship) {
        if (relationship.getSource() != null && Objects.equals(relationship.getSource().getLinkId(), this.getLinkId())) {
            this.removeSourceEntityRelationship(relationship);
        } else if (relationship.getTarget() != null && Objects.equals(relationship.getTarget().getLinkId(), this.getLinkId())) {
            this.removeTargetEntityRelationship(relationship);
        } else {
            throw new EntityException(EntityException.ErrorCode.FailedToRemoveEntityRelationship, new Object[]{relationship.getSource(), relationship.getTarget()});
        }
    }

    public void addSourceEntityRelationship(EntityRelationship relationship) {
        relationship.setSource((Reference)this.getObjectReference());
        this.sourceEntityRelationships.add(relationship);
    }

    public void removeSourceEntityRelationship(EntityRelationship relationship) {
        this.sourceEntityRelationships.remove(relationship);
    }

    public void addTargetEntityRelationship(EntityRelationship relationship) {
        relationship.setTarget((Reference)this.getObjectReference());
        this.targetEntityRelationships.add(relationship);
    }

    public void removeTargetEntityRelationship(EntityRelationship relationship) {
        this.targetEntityRelationships.remove(relationship);
    }

    public Set<EntityRelationship> getEntityRelationships() {
        HashSet<EntityRelationship> relationships = new HashSet<EntityRelationship>(this.sourceEntityRelationships);
        relationships.addAll(this.targetEntityRelationships);
        return relationships;
    }

    public void addEntityLink(EntityLink link) {
        link.setSource((Reference)this.getObjectReference());
        this.entityLinks.add(link);
    }

    public void removeEntityLink(EntityLink link) {
        this.entityLinks.remove(link);
    }

    public Set<EntityLink> getEntityLinks() {
        return this.entityLinks;
    }

    public void addClassification(Lookup classification) {
        this.classifications.add(classification);
    }

    public void removeClassification(Lookup classification) {
        this.classifications.remove(classification);
    }

    public Set<Lookup> getClassifications() {
        return this.classifications;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Entity copy = (Entity)super.clone();
        copy.classifications = new HashSet<Lookup>(this.classifications);
        copy.identities = new HashSet<org.openvpms.component.model.entity.EntityIdentity>(this.identities);
        copy.sourceEntityRelationships = new HashSet<EntityRelationship>(this.sourceEntityRelationships);
        copy.targetEntityRelationships = new HashSet<EntityRelationship>(this.targetEntityRelationships);
        copy.entityLinks = new HashSet<EntityLink>(this.entityLinks);
        return copy;
    }

    protected void setSourceEntityRelationships(Set<EntityRelationship> entityRelationships) {
        this.sourceEntityRelationships = entityRelationships;
    }

    protected void setTargetEntityRelationships(Set<EntityRelationship> entityRelationships) {
        this.targetEntityRelationships = entityRelationships;
    }

    protected void setClassifications(Set<Lookup> classifications) {
        this.classifications = classifications;
    }

    protected void setIdentities(Set<org.openvpms.component.model.entity.EntityIdentity> identities) {
        this.identities = identities;
    }
}

