/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.archetype.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathTypeConversionException;
import org.apache.commons.jxpath.util.TypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.archetype.ReadOnlyArchetypeId;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeList;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeRangeAssertion;
import org.openvpms.component.business.domain.im.archetype.descriptor.AssertionDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.Descriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorException;
import org.openvpms.component.business.domain.im.archetype.descriptor.FailedToDeriveValueException;
import org.openvpms.component.business.domain.im.archetype.descriptor.UnitsImpl;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.datatypes.property.AssertionProperty;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyCollection;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyList;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyMap;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.model.archetype.ArchetypeRange;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.model.archetype.Units;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.component.system.common.jxpath.OpenVPMSTypeConverter;
import org.openvpms.component.system.common.util.StringUtilities;

public class NodeDescriptor
extends Descriptor
implements org.openvpms.component.model.archetype.NodeDescriptor {
    public static final int DEFAULT_DISPLAY_LENGTH = 50;
    public static final String IDENTIFIER_NODE_NAME = "id";
    public static final String UNBOUNDED_AS_STRING = "*";
    private Map<String, org.openvpms.component.model.archetype.AssertionDescriptor> assertionDescriptors = new LinkedHashMap<String, org.openvpms.component.model.archetype.AssertionDescriptor>();
    private String baseName;
    private transient Class<?> clazz;
    private String defaultValue;
    private String derivedValue;
    private String displayName;
    private int index;
    private boolean isDerived = false;
    private boolean isHidden = false;
    private boolean isParentChild = true;
    private boolean isReadOnly = false;
    private boolean isArray = false;
    private int maxCardinality = 1;
    private int maxLength;
    private int minCardinality = 0;
    private int minLength;
    private Map<String, NodeDescriptor> nodeDescriptors = new LinkedHashMap<String, NodeDescriptor>();
    private String path;
    private String type;
    private String filter;
    private String modFilter;
    private NodeDescriptor parent;
    private ArchetypeDescriptor archetype;
    private static final long serialVersionUID = 2L;
    private static final TypeConverter CONVERTER = new OpenVPMSTypeConverter();
    private static final ArchetypeId NODE = new ReadOnlyArchetypeId("descriptor.node.1.0");
    private static final ArchetypeId COLLECTION_NODE = new ReadOnlyArchetypeId("descriptor.collectionNode");

    @Override
    public ArchetypeId getArchetypeId() {
        return this.nodeDescriptors == null || this.nodeDescriptors.isEmpty() ? NODE : COLLECTION_NODE;
    }

    public void addAssertionDescriptor(org.openvpms.component.model.archetype.AssertionDescriptor descriptor) {
        this.assertionDescriptors.put(descriptor.getName(), descriptor);
    }

    public void addValue(org.openvpms.component.model.object.IMObject context, Object value) {
        this.addChildToCollection((IMObject)context, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addChildToCollection(IMObject context, Object child) {
        if (context == null) {
            throw new DescriptorException(DescriptorException.ErrorCode.FailedToAddChildElement, this.getName());
        }
        if (!this.isCollection()) {
            throw new DescriptorException(DescriptorException.ErrorCode.FailedToAddChildElement, this.getName());
        }
        Object obj = JXPathHelper.newContext(context).getValue(this.getPath());
        try {
            if (StringUtils.isEmpty((CharSequence)this.baseName)) {
                Class<?> tClass = this.getClassType();
                if (Collection.class.isAssignableFrom(tClass)) {
                    MethodUtils.invokeMethod((Object)obj, (String)"add", (Object)child);
                    return;
                } else {
                    if (!Map.class.isAssignableFrom(tClass)) throw new DescriptorException(DescriptorException.ErrorCode.FailedToAddChildElement, this.getName());
                    MethodUtils.invokeMethod((Object)obj, (String)"put", (Object[])new Object[]{child, child});
                }
                return;
            } else {
                String methodName = "add" + StringUtils.capitalize((String)this.baseName);
                if (obj instanceof IMObject) {
                    MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object)child);
                    return;
                } else {
                    MethodUtils.invokeMethod((Object)context, (String)methodName, (Object)child);
                }
            }
            return;
        }
        catch (Exception exception) {
            throw new DescriptorException(DescriptorException.ErrorCode.FailedToAddChildElement, exception, this.getName());
        }
    }

    public void addNodeDescriptor(NodeDescriptor child) {
        if (this.nodeDescriptors.containsKey(child.getName())) {
            throw new DescriptorException(DescriptorException.ErrorCode.DuplicateNodeDescriptor, child.getName(), this.getName());
        }
        this.nodeDescriptors.put(child.getName(), child);
        child.setParent(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NodeDescriptor copy = (NodeDescriptor)super.clone();
        copy.assertionDescriptors = new LinkedHashMap<String, org.openvpms.component.model.archetype.AssertionDescriptor>(this.assertionDescriptors);
        copy.nodeDescriptors = new LinkedHashMap<String, NodeDescriptor>(this.nodeDescriptors);
        return copy;
    }

    public boolean containsAssertionType(String type) {
        return this.assertionDescriptors.containsKey(type);
    }

    public void deriveValue(org.openvpms.component.model.object.IMObject object) {
        if (!this.isDerived()) {
            throw new FailedToDeriveValueException(FailedToDeriveValueException.ErrorCode.DerivedValueUnsupported, new Object[]{this.getName()});
        }
        try {
            JXPathContext context = JXPathHelper.newContext(object);
            Object value = context.getValue(this.getDerivedValue());
            this.setValue(object, context, value);
        }
        catch (Exception exception) {
            throw new FailedToDeriveValueException(FailedToDeriveValueException.ErrorCode.FailedToDeriveValue, new Object[]{this.getName(), this.getPath(), this.getDerivedValue()}, exception);
        }
    }

    public String[] getArchetypeRange() {
        org.openvpms.component.model.archetype.AssertionDescriptor desc = this.assertionDescriptors.get("archetypeRange");
        if (desc != null) {
            ArrayList<String> range = new ArrayList<String>();
            PropertyList archetypes = (PropertyList)desc.getPropertyMap().getProperties().get("archetypes");
            for (NamedProperty property : archetypes.getProperties()) {
                AssertionProperty shortName = (AssertionProperty)((PropertyMap)property).getProperties().get("shortName");
                range.add(shortName.getValue());
            }
            return range.toArray(new String[0]);
        }
        return new String[0];
    }

    public ArchetypeRange getArchetypes() {
        org.openvpms.component.model.archetype.AssertionDescriptor desc = this.assertionDescriptors.get("archetypeRange");
        Object result = desc != null ? new ArchetypeRangeAssertion(desc) : (this.filter != null ? new ArchetypeList(this.filter) : ArchetypeList.EMPTY);
        return result;
    }

    public org.openvpms.component.model.archetype.AssertionDescriptor getAssertionDescriptor(String type) {
        return this.assertionDescriptors.get(type);
    }

    public Map<String, org.openvpms.component.model.archetype.AssertionDescriptor> getAssertionDescriptors() {
        return this.assertionDescriptors;
    }

    public List<AssertionDescriptor> getAssertionDescriptorsInIndexOrder() {
        ArrayList<org.openvpms.component.model.archetype.AssertionDescriptor> adescs = new ArrayList<org.openvpms.component.model.archetype.AssertionDescriptor>(this.assertionDescriptors.values());
        adescs.sort(new AssertionDescriptorIndexComparator());
        return adescs;
    }

    public AssertionDescriptor[] getAssertionDescriptorsAsArray() {
        return this.assertionDescriptors.values().toArray(new AssertionDescriptor[0]);
    }

    public void setAssertionDescriptorsAsArray(AssertionDescriptor[] assertionDescriptors) {
        this.assertionDescriptors = new LinkedHashMap<String, org.openvpms.component.model.archetype.AssertionDescriptor>();
        int i = 0;
        for (AssertionDescriptor descriptor : assertionDescriptors) {
            descriptor.setIndex(i++);
            this.addAssertionDescriptor(descriptor);
        }
    }

    public String getBaseName() {
        return this.baseName;
    }

    public List<IMObject> getChildren(org.openvpms.component.model.object.IMObject target) {
        return this.getValues(target);
    }

    public List<org.openvpms.component.model.object.IMObject> getValues(org.openvpms.component.model.object.IMObject target) {
        List<Object> result = null;
        if (this.isCollection()) {
            try {
                Object obj = JXPathHelper.newContext(target).getValue(this.getPath());
                if (obj == null) {
                    result = new ArrayList<org.openvpms.component.model.object.IMObject>();
                } else if (obj instanceof Collection) {
                    result = new ArrayList((Collection)obj);
                } else if (obj instanceof PropertyCollection) {
                    result = new ArrayList<NamedProperty>(((PropertyCollection)obj).values());
                } else if (obj instanceof Map) {
                    result = new ArrayList(((Map)obj).values());
                }
                result = this.filterChildren(result);
            }
            catch (Exception exception) {
                throw new DescriptorException(DescriptorException.ErrorCode.FailedToGetChildren, exception, target.getName(), this.getName(), this.getPath());
            }
        }
        return result;
    }

    public Class<?> getClassType() {
        return this.getClazz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getClazz() {
        if (this.clazz == null) {
            NodeDescriptor nodeDescriptor = this;
            synchronized (nodeDescriptor) {
                this.clazz = this.getClass(this.type);
            }
        }
        return this.clazz;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDerivedValue() {
        return this.derivedValue;
    }

    public int getDisplayLength() {
        return 50;
    }

    public String getDisplayName() {
        String name;
        String result = this.displayName;
        if (StringUtils.isEmpty((CharSequence)result) && (name = this.getName()) != null) {
            result = StringUtilities.unCamelCase(name);
        }
        return result;
    }

    public String getFilter() {
        return this.filter;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public String getMaxCardinalityAsString() {
        if (this.maxCardinality == -1) {
            return UNBOUNDED_AS_STRING;
        }
        return Integer.toString(this.maxCardinality);
    }

    public int getMaxLength() {
        return this.maxLength <= 0 ? 255 : this.maxLength;
    }

    public Number getMaxValue() {
        Number number = null;
        if (this.isNumeric()) {
            org.openvpms.component.model.archetype.AssertionDescriptor descriptor = this.assertionDescriptors.get("numericRange");
            if (descriptor != null) {
                number = NumberUtils.createNumber((String)this.getValue(descriptor.getPropertyMap().getProperties(), "maxValue"));
            }
        } else {
            throw new DescriptorException(DescriptorException.ErrorCode.UnsupportedOperation, "getMaxValue", this.getType());
        }
        return number;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public Number getMinValue() {
        Number number = null;
        if (this.isNumeric()) {
            org.openvpms.component.model.archetype.AssertionDescriptor descriptor = this.assertionDescriptors.get("numericRange");
            if (descriptor != null) {
                number = NumberUtils.createNumber((String)this.getValue(descriptor.getPropertyMap().getProperties(), "minValue"));
            }
        } else {
            throw new DescriptorException(DescriptorException.ErrorCode.UnsupportedOperation, "getMinValue", this.getType());
        }
        return number;
    }

    public int getNodeDescriptorCount() {
        return this.nodeDescriptors == null ? 0 : this.nodeDescriptors.size();
    }

    public Map<String, NodeDescriptor> getNodeDescriptors() {
        return this.nodeDescriptors;
    }

    public NodeDescriptor[] getNodeDescriptorsAsArray() {
        return this.nodeDescriptors.values().toArray(new NodeDescriptor[0]);
    }

    public String getPath() {
        return this.path;
    }

    public String getStringPattern() {
        String expression = null;
        if (this.isString()) {
            org.openvpms.component.model.archetype.AssertionDescriptor descriptor = this.assertionDescriptors.get("regularExpression");
            if (descriptor != null) {
                expression = this.getValue(descriptor.getPropertyMap().getProperties(), "expression");
            }
        } else {
            throw new DescriptorException(DescriptorException.ErrorCode.UnsupportedOperation, "getMinValue", this.getType());
        }
        return expression;
    }

    public Units getUnits() {
        UnitsImpl result = null;
        org.openvpms.component.model.archetype.AssertionDescriptor descriptor = this.assertionDescriptors.get("units");
        if (descriptor != null) {
            Map properties = descriptor.getPropertyMap().getProperties();
            String node = this.getValue(properties, "node");
            String displayName = this.getValue(properties, "displayName");
            if (node != null || displayName != null) {
                result = new UnitsImpl(node, displayName);
            }
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue(org.openvpms.component.model.object.IMObject context) {
        String expression;
        Object value = this.isDerived() ? ((expression = this.getDerivedValue()) != null ? JXPathHelper.newContext(context).getValue(expression) : null) : (this.isCollection() ? this.getChildren(context) : JXPathHelper.newContext(context).getValue(this.getPath()));
        return this.transform(value);
    }

    public Object getValue(JXPathContext context) {
        Object value = null;
        if (context != null) {
            value = this.isDerived() ? context.getValue(this.getDerivedValue()) : (this.isCollection() ? this.getChildren((IMObject)context.getContextBean()) : context.getValue(this.getPath()));
        }
        return value;
    }

    public boolean isBoolean() {
        Class<?> clazz = this.getClassType();
        return Boolean.class == clazz || Boolean.TYPE == clazz;
    }

    public boolean isCollection() {
        Class<?> clazz = this.getClassType();
        return clazz != null && (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || PropertyCollection.class.isAssignableFrom(clazz));
    }

    public Collection<?> toCollection(Object object) {
        Collection<Object> collection = null;
        if (object == null) {
            throw new DescriptorException(DescriptorException.ErrorCode.CannotCastToCollection);
        }
        if (object instanceof Collection) {
            collection = (Collection<NamedProperty>)object;
        } else if (object instanceof PropertyCollection) {
            collection = ((PropertyCollection)object).values();
        } else if (object instanceof Map) {
            collection = ((Map)object).values();
        }
        return collection;
    }

    public boolean isComplexNode() {
        return this.getMaxCardinality() == -1 || this.getMaxCardinality() > 1 || this.containsAssertionType("archetypeRange");
    }

    public boolean isDate() {
        Class<?> clazz = this.getClassType();
        return Date.class == clazz;
    }

    public boolean isDerived() {
        return this.isDerived;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isIdentifier() {
        return this.getName().equals(IDENTIFIER_NODE_NAME);
    }

    public boolean isLarge() {
        return this.getMaxLength() > 255;
    }

    public boolean isLookup() {
        boolean result = false;
        for (String key : this.assertionDescriptors.keySet()) {
            if (!key.startsWith("lookup")) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isMoney() {
        return this.getClassType() == Money.class;
    }

    public boolean isNumeric() {
        Class<?> clazz = this.getClassType();
        return clazz != null && (Number.class.isAssignableFrom(clazz) || Byte.TYPE == clazz || Short.TYPE == clazz || Integer.TYPE == clazz || Long.TYPE == clazz || Float.TYPE == clazz || Double.TYPE == clazz);
    }

    public boolean isObjectReference() {
        return IMObjectReference.class.isAssignableFrom(this.getClassType());
    }

    public boolean isParentChild() {
        return this.isParentChild && this.isCollection();
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isRequired() {
        return this.getMinCardinality() > 0;
    }

    public boolean isString() {
        return String.class == this.getClassType();
    }

    public boolean matchesFilter(IMObject imobj) {
        boolean matches = false;
        if (this.isCollection()) {
            if (StringUtils.isEmpty((CharSequence)this.filter)) {
                matches = true;
            } else {
                String shortName = imobj.getArchetype();
                matches = shortName.matches(this.modFilter);
            }
        }
        return matches;
    }

    public void removeAssertionDescriptor(org.openvpms.component.model.archetype.AssertionDescriptor descriptor) {
        this.assertionDescriptors.remove(descriptor.getName());
    }

    public void removeAssertionDescriptor(String type) {
        this.assertionDescriptors.remove(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeChildFromCollection(IMObject context, Object child) {
        if (context == null) {
            throw new DescriptorException(DescriptorException.ErrorCode.FailedToRemoveChildElement, this.getName());
        }
        if (!this.isCollection()) {
            throw new DescriptorException(DescriptorException.ErrorCode.FailedToRemoveChildElement, this.getName());
        }
        Object obj = JXPathHelper.newContext(context).getValue(this.getPath());
        try {
            if (StringUtils.isEmpty((CharSequence)this.baseName)) {
                Class<?> clazz = this.getClassType();
                if (Collection.class.isAssignableFrom(clazz)) {
                    MethodUtils.invokeMethod((Object)obj, (String)"remove", (Object)child);
                    return;
                } else {
                    if (!Map.class.isAssignableFrom(clazz)) throw new DescriptorException(DescriptorException.ErrorCode.FailedToRemoveChildElement, this.getName());
                    MethodUtils.invokeMethod((Object)obj, (String)"remove", (Object)child);
                }
                return;
            } else {
                String methodName = "remove" + StringUtils.capitalize((String)this.baseName);
                if (obj instanceof IMObject) {
                    MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object)child);
                    return;
                } else {
                    MethodUtils.invokeMethod((Object)context, (String)methodName, (Object)child);
                }
            }
            return;
        }
        catch (Exception exception) {
            throw new DescriptorException(DescriptorException.ErrorCode.FailedToRemoveChildElement, exception, this.getName());
        }
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDerived(boolean isDerived) {
        this.isDerived = isDerived;
    }

    public void setDerivedValue(String derivedValue) {
        this.derivedValue = derivedValue;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        if (!StringUtils.isEmpty((CharSequence)filter)) {
            this.modFilter = filter.replace(UNBOUNDED_AS_STRING, ".*");
        }
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setMaxCardinality(int maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public void setMaxCardinalityAsString(String maxCardinality) {
        if (maxCardinality.equals(UNBOUNDED_AS_STRING)) {
            this.setMaxCardinality(-1);
        } else {
            this.setMaxCardinality(Integer.parseInt(maxCardinality));
        }
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinCardinality(int minCardinality) {
        this.minCardinality = minCardinality;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setNodeDescriptorsAsArray(NodeDescriptor[] nodes) {
        this.nodeDescriptors = new LinkedHashMap<String, NodeDescriptor>();
        int i = 0;
        for (NodeDescriptor node : nodes) {
            node.setIndex(i++);
            this.addNodeDescriptor(node);
        }
    }

    public void setParentChild(boolean parentChild) {
        this.isParentChild = parentChild;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setReadOnly(boolean value) {
        this.isReadOnly = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            this.type = null;
        } else if (type.endsWith("[]")) {
            this.isArray = true;
            this.type = type.substring(0, type.indexOf("[]"));
        } else {
            this.type = type;
        }
        NodeDescriptor nodeDescriptor = this;
        synchronized (nodeDescriptor) {
            this.clazz = null;
        }
    }

    public void setValue(org.openvpms.component.model.object.IMObject object, Object value) {
        if (object == null) {
            throw new DescriptorException(DescriptorException.ErrorCode.NullContextForSetValue, this.getName());
        }
        this.setValue(object, JXPathHelper.newContext(object), value);
    }

    public void setValue(org.openvpms.component.model.object.IMObject object, JXPathContext context, Object value) {
        try {
            for (AssertionDescriptor descriptor : this.getAssertionDescriptorsAsArray()) {
                value = descriptor.set(value, (IMObject)object, this);
            }
            if (this.isArray) {
                context.setValue(this.getPath(), value);
            } else {
                context.setValue(this.getPath(), this.transform(value));
            }
        }
        catch (Exception exception) {
            throw new DescriptorException(DescriptorException.ErrorCode.FailedToSetValue, exception, this.getName());
        }
    }

    public ArchetypeDescriptor getArchetypeDescriptor() {
        return this.archetype;
    }

    public NodeDescriptor getParent() {
        return this.parent;
    }

    public void setArchetypeDescriptor(ArchetypeDescriptor descriptor) {
        this.archetype = descriptor;
    }

    public void setParent(NodeDescriptor parent) {
        this.parent = parent;
    }

    private List<org.openvpms.component.model.object.IMObject> filterChildren(List<org.openvpms.component.model.object.IMObject> children) {
        if (StringUtils.isEmpty((CharSequence)this.filter)) {
            return children;
        }
        ArrayList<org.openvpms.component.model.object.IMObject> filteredSet = new ArrayList<org.openvpms.component.model.object.IMObject>();
        for (org.openvpms.component.model.object.IMObject obj : children) {
            if (!obj.isA(this.filter)) continue;
            filteredSet.add(obj);
        }
        return filteredSet;
    }

    private Object transform(Object value) {
        if (value == null || this.isCollection() || value.getClass() == this.getClassType()) {
            return value;
        }
        try {
            return CONVERTER.convert(value, this.getClassType());
        }
        catch (JXPathTypeConversionException exception) {
            throw new DescriptorException(DescriptorException.ErrorCode.FailedToCoerceValue, value.getClass().getName(), this.getClassType().getName());
        }
    }

    private String getValue(Map<String, NamedProperty> properties, String name) {
        NamedProperty property = properties.get(name);
        return property != null ? (String)property.getValue() : null;
    }

    private static class AssertionDescriptorIndexComparator
    implements Comparator<org.openvpms.component.model.archetype.AssertionDescriptor> {
        private AssertionDescriptorIndexComparator() {
        }

        @Override
        public int compare(org.openvpms.component.model.archetype.AssertionDescriptor no1, org.openvpms.component.model.archetype.AssertionDescriptor no2) {
            if (no1 == no2) {
                return 0;
            }
            return Integer.compare(no1.getIndex(), no2.getIndex());
        }
    }
}

