/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.im.archetype.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorException;
import org.xml.sax.InputSource;

class DescriptorIOHelper {
    private static final String UNKNOWN_MAPPING_PATH = "<unknown mapping path>";

    private DescriptorIOHelper() {
    }

    public static Object read(InputStream stream, String mappingPath) {
        Mapping mapping = DescriptorIOHelper.getMapping(mappingPath);
        Object result = DescriptorIOHelper.read(stream, mapping, mappingPath);
        return result;
    }

    public static Object read(InputStream stream, Mapping mapping) {
        Object result = DescriptorIOHelper.read(stream, mapping, UNKNOWN_MAPPING_PATH);
        return result;
    }

    public static Object read(File file, Mapping mapping) throws FileNotFoundException {
        Object result;
        try {
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            result = unmarshaller.unmarshal((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            throw new DescriptorException(DescriptorException.ErrorCode.FileReadError, exception, file.getAbsolutePath(), UNKNOWN_MAPPING_PATH, exception.getMessage());
        }
        return result;
    }

    public static void write(Object object, OutputStream stream, String mappingPath) {
        Mapping mapping = DescriptorIOHelper.getMapping(mappingPath);
        DescriptorIOHelper.write(object, stream, mapping, mappingPath, false, false);
    }

    public static void write(Object object, OutputStream stream, Mapping mapping) {
        DescriptorIOHelper.write(object, stream, mapping, false, false);
    }

    public static void write(Object object, OutputStream stream, Mapping mapping, boolean fragment, boolean prettyPrint) {
        DescriptorIOHelper.write(object, stream, mapping, UNKNOWN_MAPPING_PATH, fragment, prettyPrint);
    }

    public static Mapping getMapping(String path) {
        InputStream stream;
        Mapping mapping = new Mapping();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = DescriptorIOHelper.class.getClassLoader();
        }
        if ((stream = loader.getResourceAsStream(path)) == null) {
            throw new DescriptorException(DescriptorException.ErrorCode.MappingNotFound, path);
        }
        try {
            InputSource source = new InputSource(new InputStreamReader(stream));
            source.setSystemId(path);
            mapping.loadMapping(source);
        }
        catch (Exception exception) {
            throw new DescriptorException(DescriptorException.ErrorCode.MappingError, exception, path);
        }
        return mapping;
    }

    private static Object read(InputStream stream, Mapping mapping, String mappingPath) {
        Object result;
        try {
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            result = unmarshaller.unmarshal((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            throw new DescriptorException(DescriptorException.ErrorCode.ReadError, exception, mappingPath, exception.getMessage());
        }
        return result;
    }

    private static void write(Object object, OutputStream stream, Mapping mapping, String mappingPath, boolean fragment, boolean prettyPrint) {
        OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
        try {
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setMapping(mapping);
            if (prettyPrint) {
                marshaller.setSuppressNamespaces(true);
                marshaller.setSuppressXSIType(true);
                marshaller.setProperty("org.exolab.castor.indent", "true");
            }
            marshaller.setMarshalAsDocument(!fragment);
            marshaller.marshal(object);
            writer.flush();
        }
        catch (Exception exception) {
            throw new DescriptorException(DescriptorException.ErrorCode.WriteError, exception, mappingPath, exception.getMessage());
        }
    }
}

