/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.archetype;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeIdException;
import org.openvpms.component.business.domain.archetype.QualifiedName;
import org.openvpms.component.business.domain.archetype.ShortName;

public class ArchetypeId
implements Serializable,
Cloneable {
    public static final ArchetypeId LOCAL_LOOKUP_ID = new ArchetypeId("lookup.local.1.0");
    private String namespace;
    private String rmName;
    private String entityName;
    private String concept;
    private String version;
    private String qualifiedName;
    private String shortName;
    private static final long serialVersionUID = 2L;

    protected ArchetypeId() {
    }

    public ArchetypeId(String qname) {
        this.setQualified(qname);
    }

    public ArchetypeId(String entityName, String concept, String version) {
        if (StringUtils.isEmpty((CharSequence)concept) || StringUtils.isEmpty((CharSequence)entityName)) {
            throw new ArchetypeIdException(ArchetypeIdException.ErrorCode.EmptyElement);
        }
        this.concept = concept;
        this.entityName = entityName;
        this.version = version;
    }

    public ArchetypeId(String archetype, String version) {
        this.setShortName(ShortName.get(archetype));
        this.version = version;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getConcept() {
        return this.concept;
    }

    public String getVersion() {
        return this.version;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            StringBuilder buff = new StringBuilder(this.getShortName());
            if (!StringUtils.isEmpty((CharSequence)this.version)) {
                buff.append(".").append(this.version);
            }
            this.qualifiedName = buff.toString();
        }
        return this.qualifiedName;
    }

    @Deprecated
    public String getNamespace() {
        return this.namespace;
    }

    @Deprecated
    public String getRmName() {
        return this.rmName;
    }

    public String getShortName() {
        if (this.shortName == null) {
            this.shortName = this.entityName + "." + this.concept;
        }
        return this.shortName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArchetypeId)) {
            return false;
        }
        ArchetypeId rhs = (ArchetypeId)obj;
        if (Objects.equals(this.getShortName(), rhs.getShortName())) {
            if (this.version != null && rhs.getVersion() != null) {
                return this.version.equals(rhs.getVersion());
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getShortName().hashCode();
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public Object clone() throws CloneNotSupportedException {
        ArchetypeId copy = (ArchetypeId)super.clone();
        copy.concept = this.concept;
        copy.entityName = this.entityName;
        copy.qualifiedName = this.qualifiedName;
        copy.shortName = this.shortName;
        copy.version = this.version;
        return copy;
    }

    @Deprecated
    protected void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Deprecated
    protected void setRmName(String rmName) {
        this.rmName = rmName;
    }

    @Deprecated
    protected void setEntityName(String entityName) {
        this.entityName = entityName;
        this.shortName = null;
        this.qualifiedName = null;
    }

    @Deprecated
    protected void setConcept(String concept) {
        this.concept = concept;
        this.shortName = null;
        this.qualifiedName = null;
    }

    protected void setQualifiedName(String qname) {
        this.setQualified(qname);
    }

    protected void setShortName(String shortName) {
        this.setShortName(ShortName.get(shortName));
    }

    protected void setVersion(String version) {
        this.version = version;
        this.qualifiedName = null;
    }

    private void setQualified(String qname) {
        QualifiedName cached = QualifiedName.get(qname);
        this.setShortName(ShortName.get(cached.getShortName()));
        this.version = cached.getVersion();
        this.qualifiedName = cached.getQualifiedName();
    }

    private void setShortName(ShortName shortName) {
        this.entityName = shortName.getEntityName();
        this.concept = shortName.getConcept();
        this.shortName = shortName.getShortName();
    }
}

