/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.factory;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.event.WorkingMemoryEventListener;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class WorkingMemoryFactoryBean
implements FactoryBean,
InitializingBean,
ApplicationContextAware {
    private static Log log = LogFactory.getLog((Class)WorkingMemoryFactoryBean.class);
    private RuleBase ruleBase;
    private boolean autoDetectListeners;
    private Set listeners;
    private ApplicationContext applicationContext;
    private Map applicationData;
    private WorkingMemory workingMemory;

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public void setAutoDetectListeners(boolean autoRegisterListeners) {
        this.autoDetectListeners = autoRegisterListeners;
    }

    public void setListeners(Set listeners) {
        this.listeners = listeners;
    }

    public void setApplicationData(Map data) {
        this.applicationData = data;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ruleBase == null) {
            throw new IllegalArgumentException("ruleBase not set");
        }
        if (this.autoDetectListeners) {
            this.addListenerAutodetectBeanPostProcessor();
        }
    }

    private void addListenerAutodetectBeanPostProcessor() {
        if (!(this.applicationContext instanceof ConfigurableApplicationContext)) {
            log.warn((Object)("Cannot autodetect WorkingMemoryListeners; beanFactory is not instanceof ConfigurableApplicationContext: beanFactory.class=" + this.applicationContext.getClass()));
        } else {
            ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
            beanFactory.addBeanPostProcessor(new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                    return bean;
                }

                public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                    if (bean == WorkingMemoryFactoryBean.this) {
                        WorkingMemoryFactoryBean.this.autoDetectListeners();
                    }
                    return bean;
                }
            });
        }
    }

    private void autoDetectListeners() throws BeansException {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        Map listenerBeans = this.applicationContext.getBeansOfType(WorkingMemoryEventListener.class, false, false);
        Iterator iter = listenerBeans.values().iterator();
        while (iter.hasNext()) {
            WorkingMemoryEventListener listener = (WorkingMemoryEventListener)iter.next();
            this.listeners.add(listener);
        }
    }

    private WorkingMemory createObject() {
        WorkingMemory workingMemory = this.ruleBase.newWorkingMemory();
        this.addApplicationData(workingMemory);
        this.addListeners(workingMemory);
        return workingMemory;
    }

    private void addApplicationData(WorkingMemory workingMemory) {
        if (this.applicationData != null) {
            Iterator iter = this.applicationData.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                workingMemory.setApplicationData((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void addListeners(WorkingMemory workingMemory) {
        if (this.listeners != null) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WorkingMemoryEventListener listener = (WorkingMemoryEventListener)iter.next();
                workingMemory.addEventListener(listener);
            }
        }
    }

    public Class getObjectType() {
        return WorkingMemory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getObject() throws Exception {
        if (this.workingMemory == null) {
            this.workingMemory = this.createObject();
        }
        return this.workingMemory;
    }
}

