/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.examples.jiahvac.control.rules;

import org.drools.spring.examples.jiahvac.model.HeatPump;
import org.drools.spring.examples.jiahvac.model.TempuratureControl;
import org.drools.spring.examples.jiahvac.model.Thermometer;
import org.drools.spring.examples.jiahvac.model.Vent;
import org.drools.spring.metadata.annotation.java.Condition;
import org.drools.spring.metadata.annotation.java.Consequence;
import org.drools.spring.metadata.annotation.java.Rule;

@Rule
public class OpenVentWhenHeatingVentClosedFloorTooCold {
    private TempuratureControl control;

    public void setControl(TempuratureControl control) {
        this.control = control;
    }

    @Condition
    public boolean isPumpHeating(HeatPump pump) {
        return pump.getState() == HeatPump.State.HEATING;
    }

    @Condition
    public boolean isVentClosed(Vent vent) {
        return vent.getState() == Vent.State.CLOSED;
    }

    @Condition
    public boolean isSameFloor(Vent vent, Thermometer thermometer, HeatPump pump) {
        return vent.getFloor() == thermometer.getFloor() && vent.getFloor().getHeatPump() == pump;
    }

    @Condition
    public boolean isNotWarmEnough(Thermometer thermometer) {
        return !this.control.isWarmEnough(thermometer.getReading());
    }

    @Consequence
    public void consequence(Vent vent) {
        vent.setState(Vent.State.OPEN);
        System.out.println("OpenVentWhenHeatingVentClosedFloorTooCold: " + vent + ", " + vent.getFloor().getThermometer());
    }
}

