/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.python;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.python.NonBooleanExprException;
import org.drools.semantics.python.PythonExprAnalyzer;
import org.drools.semantics.python.PythonInterp;
import org.drools.spi.Condition;
import org.drools.spi.ConditionException;
import org.drools.spi.Tuple;
import org.python.core.PyObject;
import org.python.core.__builtin__;

public class PythonCondition
extends PythonInterp
implements Condition {
    private Declaration[] requiredDeclarations;

    public PythonCondition(String text, Rule rule) throws Exception {
        super(text, rule, "eval");
        PythonExprAnalyzer analyzer = new PythonExprAnalyzer();
        this.requiredDeclarations = analyzer.analyze(this.getNode(), rule.getParameterDeclarations());
    }

    public boolean isAllowed(Tuple tuple) throws ConditionException {
        try {
            PyObject result = __builtin__.eval((PyObject)this.getCode(), (PyObject)this.setUpDictionary(tuple, this.declarationIterator()), (PyObject)this.getGlobals());
            Object answer = result.__tojava__(Object.class);
            if (!(answer instanceof Number)) {
                throw new NonBooleanExprException(this.getText());
            }
            return ((Number)answer).intValue() != 0;
        }
        catch (Exception e) {
            throw new ConditionException(e, this.getRule(), this.getText());
        }
    }

    public Declaration[] getRequiredTupleMembers() {
        return this.requiredDeclarations;
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getText().equals(((PythonInterp)object).getText());
    }

    public Iterator declarationIterator() {
        return new Iterator(){
            private int index = 0;

            public void remove() {
            }

            public boolean hasNext() {
                return this.index < PythonCondition.this.requiredDeclarations.length;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return PythonCondition.this.requiredDeclarations[this.index++];
            }
        };
    }
}

