/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.java;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.codehaus.janino.Scanner;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.java.CompilationException;
import org.drools.semantics.java.JavaCompiler;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.DefaultKnowledgeHelper;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Tuple;

public class JavaBlockConsequence
implements Consequence,
Serializable {
    private final String block;
    private final Rule rule;
    private final Declaration[] declarations;
    private final String className;
    private transient Script script;

    public JavaBlockConsequence(Rule rule, int id, String block) throws Exception {
        this.block = block;
        this.rule = rule;
        List declarations = rule.getParameterDeclarations();
        this.declarations = declarations.toArray(new Declaration[declarations.size()]);
        this.className = "Consequence_" + id;
        this.script = this.compile();
    }

    public void invoke(Tuple tuple) throws ConsequenceException {
        try {
            if (this.script == null) {
                this.script = this.compile();
            }
            this.script.invoke(tuple, this.declarations, new DefaultKnowledgeHelper(this.rule, tuple), tuple.getWorkingMemory().getApplicationDataMap());
        }
        catch (Scanner.LocatedException e) {
            throw new ConsequenceException(e, this.rule, this.block);
        }
        catch (CompilationException e) {
            throw new ConsequenceException(e.getMessage(), e.getRule(), e.getText());
        }
        catch (Exception e) {
            throw new ConsequenceException(e, this.rule, this.block);
        }
    }

    private Script compile() throws Exception {
        return (Script)JavaCompiler.compile(this.rule, this.className, Script.class, this.block, this.block, this.declarations);
    }

    public String toString() {
        return "[Consequence: " + this.block + "]";
    }

    public static interface Script {
        public void invoke(Tuple var1, Declaration[] var2, KnowledgeHelper var3, Map var4) throws Exception;
    }
}

