/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.reteoo.AgendaItem;
import org.drools.reteoo.AgendaItemMap;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.Scheduler;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Rule;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AsyncExceptionHandler;
import org.drools.spi.ConflictResolver;
import org.drools.spi.ConsequenceException;
import org.drools.spi.Duration;
import org.drools.spi.Tuple;
import org.drools.util.PriorityQueue;

class Agenda
implements Serializable {
    public static int NONE = 0;
    public static int ASSERT = 1;
    public static int MODIFY = 2;
    public static int RETRACT = 3;
    private final WorkingMemoryImpl workingMemory;
    private final PriorityQueue activationQueue;
    private final Map scheduledItems;
    private final AgendaItemMap itemsToRetract;
    private final AgendaItemMap scheduledItemsToRetract;
    private AgendaItem item;
    private int mode = 0;

    public Agenda(WorkingMemoryImpl workingMemory, ConflictResolver conflictResolver) {
        this.workingMemory = workingMemory;
        this.activationQueue = new PriorityQueue(conflictResolver);
        this.scheduledItems = new HashMap();
        this.itemsToRetract = new AgendaItemMap();
        this.scheduledItemsToRetract = new AgendaItemMap();
    }

    public List getActivations() {
        ArrayList activations = new ArrayList();
        activations.addAll(this.activationQueue);
        activations.addAll(this.scheduledItems.values());
        return activations;
    }

    void addToAgenda(ReteTuple tuple, Rule rule) {
        if (this.item != null && rule.isNoLoop() && rule.equals(this.item.getRule()) && this.item.getKey().equals(tuple.getKey())) {
            return;
        }
        Duration dur = rule.getDuration();
        if (dur != null && dur.getDuration(tuple) > 0L) {
            AgendaItem item = null;
            if (!this.scheduledItemsToRetract.isEmpty()) {
                item = this.scheduledItemsToRetract.removeAgendaItem(rule, tuple.getKey());
            }
            if (item == null) {
                item = new AgendaItem(tuple, rule);
                this.scheduledItems.put(item.getKey(), item);
                this.scheduleItem(item);
                this.workingMemory.getEventSupport().fireActivationCreated(rule, tuple);
            }
        } else {
            AgendaItem item = null;
            if (!this.itemsToRetract.isEmpty()) {
                item = this.itemsToRetract.removeAgendaItem(rule, tuple.getKey());
            }
            if (item == null) {
                item = new AgendaItem(tuple, rule);
                this.activationQueue.add(item);
                this.workingMemory.getEventSupport().fireActivationCreated(rule, tuple);
            } else {
                this.activationQueue.add(item);
            }
        }
    }

    void removeFromAgenda(TupleKey key, Rule rule) {
        AgendaItem eachItem;
        Iterator itemIter = this.activationQueue.iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.getKey().containsAll(key)) continue;
            itemIter.remove();
            itemIter = this.activationQueue.iterator();
            if (this.mode == MODIFY && !this.workingMemory.getEventSupport().isEmpty()) {
                this.itemsToRetract.putAgendaItem(rule, eachItem.getKey(), eachItem);
                continue;
            }
            this.workingMemory.getEventSupport().fireActivationCancelled(rule, eachItem.getTuple());
        }
        itemIter = this.scheduledItems.values().iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.getKey().containsAll(key)) continue;
            if (this.mode == MODIFY && !this.workingMemory.getEventSupport().isEmpty()) {
                this.scheduledItemsToRetract.putAgendaItem(rule, eachItem.getKey(), eachItem);
                continue;
            }
            Tuple tuple = eachItem.getTuple();
            this.cancelItem(eachItem);
            itemIter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(rule, tuple);
        }
    }

    void removeXorGroupFromAgenda(TupleKey key, String xorGroup) {
        AgendaItem eachItem;
        if (xorGroup == null) {
            return;
        }
        Iterator itemIter = this.activationQueue.iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (!xorGroup.equals(eachItem.getRule().getXorGroup())) continue;
            itemIter.remove();
            itemIter = this.activationQueue.iterator();
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
        }
        itemIter = this.scheduledItems.values().iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (!xorGroup.equals(eachItem.getRule().getXorGroup())) continue;
            Tuple tuple = eachItem.getTuple();
            this.cancelItem(eachItem);
            itemIter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), tuple);
        }
    }

    void removeMarkedItemsFromAgenda() {
        AgendaItemMap.RemoveDelegate delegate = new AgendaItemMap.RemoveDelegate(){

            public void processRemove(Object obj) {
                AgendaItem eachItem = (AgendaItem)obj;
                Agenda.this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
            }
        };
        this.itemsToRetract.removeAll(delegate);
        AgendaItemMap.RemoveDelegate scheduledDelegate = new AgendaItemMap.RemoveDelegate(){

            public void processRemove(Object obj) {
                AgendaItem eachItem = (AgendaItem)obj;
                Agenda.this.cancelItem(eachItem);
                Agenda.this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
            }
        };
        this.scheduledItemsToRetract.removeAll(scheduledDelegate);
    }

    void clearAgenda() {
        AgendaItem eachItem;
        Iterator iter = this.activationQueue.iterator();
        while (iter.hasNext()) {
            eachItem = (AgendaItem)iter.next();
            iter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
        }
        iter = this.scheduledItems.values().iterator();
        while (iter.hasNext()) {
            eachItem = (AgendaItem)iter.next();
            this.cancelItem(eachItem);
            iter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
        }
    }

    void scheduleItem(AgendaItem item) {
        Scheduler.getInstance().scheduleAgendaItem(item, this.workingMemory);
    }

    void cancelItem(AgendaItem item) {
        Scheduler.getInstance().cancelAgendaItem(item);
    }

    public boolean isEmpty() {
        return this.activationQueue.isEmpty();
    }

    public int size() {
        return this.activationQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNextItem(AgendaFilter filter) throws ConsequenceException {
        if (this.isEmpty()) {
            return;
        }
        this.item = (AgendaItem)this.activationQueue.remove();
        String xorGroup = this.item.getRule().getXorGroup();
        if (xorGroup != null) {
            this.removeXorGroupFromAgenda(this.item.getKey(), xorGroup);
        }
        try {
            if (filter == null || filter.accept(this.item)) {
                this.item.fire(this.workingMemory);
            }
        }
        finally {
            this.item = null;
        }
    }

    void setAsyncExceptionHandler(AsyncExceptionHandler handler) {
        Scheduler.getInstance().setAsyncExceptionHandler(handler);
    }

    void setMode(int mode) {
        this.mode = mode;
    }
}

