/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.primefactors;

import org.drools.examples.primefactors.Number;
import org.drools.rule.Declaration;
import org.drools.spi.Consequence;
import org.drools.spi.Tuple;

public class FactorConsequence
implements Consequence {
    private final Declaration numberDecl;
    private final int prime;

    public FactorConsequence(Declaration numberDecl, int prime) {
        this.numberDecl = numberDecl;
        this.prime = prime;
    }

    public void invoke(Tuple tuple) {
        Number number = (Number)tuple.get(this.numberDecl);
        do {
            number.addFactor(this.prime);
            number.setQuotient(number.getQuotient() / this.prime);
        } while (number.getQuotient() % this.prime == 0);
    }

    public String toString() {
        return "Factor out " + this.prime + "'s";
    }
}

