/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.workflow.ScheduleEventQuery;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.util.PropertySet;

public abstract class ScheduleEventFactory {
    private final IArchetypeService service;
    private final Map<String, String> statusNames;

    protected ScheduleEventFactory(String eventShortName, IArchetypeService service, LookupService lookups) {
        this(LookupHelper.getNames((IArchetypeService)service, (LookupService)lookups, (String)eventShortName, (String)"status"), service);
    }

    protected ScheduleEventFactory(Map<String, String> statusNames, IArchetypeService service) {
        this.service = service;
        this.statusNames = statusNames;
    }

    public List<PropertySet> getEvents(Reference reference, Date startTime, Date endTime) {
        Entity entity = (Entity)this.service.get(reference);
        if (entity == null) {
            throw new IllegalStateException("Cannot locate entity with reference=" + reference);
        }
        return this.getEvents(entity, startTime, endTime);
    }

    public List<PropertySet> getEvents(Entity entity, Date startTime, Date endTime) {
        ScheduleEventQuery query = this.createQuery(entity, startTime, endTime);
        IPage<ObjectSet> page = query.query();
        return new ArrayList<PropertySet>(page.getResults());
    }

    public PropertySet createEvent(Act act) {
        ObjectSet set = new ObjectSet();
        IMObjectBean bean = this.service.getBean((IMObject)act);
        this.assemble((PropertySet)set, bean);
        return set;
    }

    protected void assemble(PropertySet target, IMObjectBean source) {
        Act event = (Act)source.getObject(Act.class);
        String status = event.getStatus();
        target.set("act.version", (Object)event.getVersion());
        target.set("act.objectReference", (Object)event.getObjectReference());
        target.set("act.startTime", (Object)event.getActivityStartTime());
        target.set("act.endTime", (Object)event.getActivityEndTime());
        target.set("act.status", (Object)status);
        target.set("act.statusName", (Object)this.statusNames.get(status));
        target.set("notes", (Object)source.getString("notes"));
        this.populate(target, source, "customer");
        this.populate(target, source, "patient");
        this.populate(target, source, "clinician");
    }

    protected void populate(PropertySet target, IMObjectBean source, String node) {
        Participation participation = null;
        if (source.hasNode(node)) {
            participation = (Participation)source.getObject(node, Participation.class);
        }
        this.populate(target, participation, node);
    }

    protected void populate(PropertySet target, Participation source, String node) {
        Reference reference = null;
        String name = null;
        long version = -1L;
        if (source != null) {
            reference = source.getEntity();
            name = this.getName(reference);
            version = source.getVersion();
        }
        target.set(node + ".objectReference", (Object)reference);
        target.set(node + ".name", (Object)name);
        target.set(node + "Participation.version", (Object)version);
    }

    protected abstract ScheduleEventQuery createQuery(Entity var1, Date var2, Date var3);

    protected IArchetypeService getService() {
        return this.service;
    }

    protected String getName(Reference reference) {
        if (reference != null) {
            ObjectRefConstraint constraint = new ObjectRefConstraint("o", reference);
            ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)constraint);
            query.add((IConstraint)new NodeSelectConstraint("o.name"));
            query.setMaxResults(1);
            ObjectSetQueryIterator iter = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
            if (iter.hasNext()) {
                ObjectSet set = (ObjectSet)iter.next();
                return set.getString("o.name");
            }
        }
        return null;
    }

    protected Map<String, String> getStatusNames() {
        return this.statusNames;
    }
}

