/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import java.util.List;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;

public class CalendarBlock {
    private final Act act;
    private final IMObjectBean blockType;
    private final boolean reserved;

    public CalendarBlock(Act act, Entity blockType, boolean reserved, IArchetypeService service) {
        this.act = act;
        this.blockType = service.getBean((IMObject)blockType);
        this.reserved = reserved;
    }

    public Reference getReference() {
        return this.act.getObjectReference();
    }

    public Entity getBlockType() {
        return (Entity)this.blockType.getObject(Entity.class);
    }

    public String getName() {
        return this.act.getName() != null ? this.act.getName() : this.getBlockType().getName();
    }

    public Date getStartTime() {
        return this.act.getActivityStartTime();
    }

    public Date getEndTime() {
        return this.act.getActivityEndTime();
    }

    public List<Lookup> getCustomerAccountTypes() {
        return this.blockType.getValues("customerAccountTypes", Lookup.class);
    }

    public List<Lookup> getCustomerTypes() {
        return this.blockType.getValues("customerTypes", Lookup.class);
    }

    public boolean isReserved() {
        return this.reserved;
    }
}

