/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.Date;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class CageType {
    private final IMObjectBean bean;

    public CageType(Entity entity, ArchetypeService service) {
        this.bean = service.getBean((IMObject)entity);
    }

    public Product getFirstPetProductDay() {
        return (Product)this.bean.getTarget("firstPetProductDay", Product.class);
    }

    public Product getSecondPetProductDay() {
        return (Product)this.bean.getTarget("secondPetProductDay", Product.class);
    }

    public Product getFirstPetProductOvernight() {
        return (Product)this.bean.getTarget("firstPetProductNight", Product.class);
    }

    public Product getSecondPetProductOvernight() {
        return (Product)this.bean.getTarget("secondPetProductNight", Product.class);
    }

    public Product getProduct(int days, boolean overnight, boolean firstPet) {
        Product result = firstPet ? this.getFirstPetProduct(days, overnight) : this.getSecondPetProduct(days, overnight);
        return result;
    }

    public boolean isLateCheckout(Date time) {
        Date lateCheckoutTime = this.bean.getDate("lateCheckoutTime");
        if (lateCheckoutTime != null) {
            LocalTime l1 = new LocalTime((Object)lateCheckoutTime);
            LocalTime l2 = new LocalTime((Object)time);
            return l1.compareTo((ReadablePartial)l2) <= 0;
        }
        return false;
    }

    public Product getLateCheckoutProduct() {
        return (Product)this.bean.getTarget("lateCheckoutProduct", Product.class);
    }

    public boolean hasSecondPetProducts() {
        return this.bean.getTargetRef("secondPetProductDay") != null || this.bean.getTargetRef("secondPetProductNight") != null;
    }

    public boolean equals(Object obj) {
        return obj instanceof CageType && this.bean.getObject().equals(((CageType)obj).bean.getObject());
    }

    public int hashCode() {
        return this.bean.getObject().hashCode();
    }

    protected Product getFirstPetProduct(int days, boolean overnight) {
        Product result = null;
        if (days > 1 || overnight) {
            result = this.getFirstPetProductOvernight();
        }
        if (result == null) {
            result = this.getFirstPetProductDay();
        }
        return result;
    }

    protected Product getSecondPetProduct(int days, boolean overnight) {
        Product result = null;
        if (days > 1 || overnight) {
            result = this.getSecondPetProductOvernight();
        }
        if (result == null) {
            result = this.getSecondPetProductDay();
        }
        if (result == null) {
            result = this.getFirstPetProduct(days, overnight);
        }
        return result;
    }
}

