/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class AppointmentReminderConfig {
    private final Period noReminderPeriod;
    private final boolean processReplies;
    private final String confirm;
    private final String cancel;

    public AppointmentReminderConfig(Entity config, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)config);
        int period = bean.getInt("noReminder");
        DateUnits units = DateUnits.fromString(bean.getString("noReminderUnits"));
        this.noReminderPeriod = period > 0 && units != null ? units.toPeriod(period) : null;
        this.processReplies = bean.getBoolean("processReplies");
        this.confirm = StringUtils.trimToNull((String)bean.getString("confirmAppointment"));
        this.cancel = StringUtils.trimToNull((String)bean.getString("cancelAppointment"));
    }

    public Period getNoReminderPeriod() {
        return this.noReminderPeriod;
    }

    public boolean processReplies() {
        return this.processReplies;
    }

    public boolean containsConfirmation(String message) {
        return StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)this.confirm);
    }

    public boolean containsCancellation(String message) {
        return StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)this.cancel);
    }

    public Match isConfirmation(String inboundMessage, String outboundMessage) {
        return this.matches(inboundMessage, outboundMessage, this.confirm, this.cancel);
    }

    public Match isCancellation(String inboundMessage, String outboundMessage) {
        return this.matches(inboundMessage, outboundMessage, this.cancel, this.confirm);
    }

    public String getConfirmText() {
        return this.confirm;
    }

    public String getCancelText() {
        return this.cancel;
    }

    private Match matches(String inboundMessage, String outboundMessage, String text, String notText) {
        Match result = Match.NO_MATCH;
        if (StringUtils.containsIgnoreCase((CharSequence)outboundMessage, (CharSequence)text)) {
            if (text.equalsIgnoreCase(inboundMessage)) {
                result = Match.EXACT;
            } else if (StringUtils.containsIgnoreCase((CharSequence)inboundMessage, (CharSequence)text)) {
                if (notText == null) {
                    result = Match.CONTAINS;
                } else if (StringUtils.containsIgnoreCase((CharSequence)outboundMessage, (CharSequence)notText) && !StringUtils.containsIgnoreCase((CharSequence)inboundMessage, (CharSequence)notText)) {
                    result = Match.CONTAINS;
                }
            }
        }
        return result;
    }

    public static enum Match {
        EXACT,
        CONTAINS,
        NO_MATCH;


        public boolean isMatch() {
            return this != NO_MATCH;
        }
    }
}

