/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AbstractScheduleService;
import org.openvpms.archetype.rules.workflow.ScheduleEventFactory;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.RelationalOp;
import org.openvpms.component.system.common.util.PropertySet;

public abstract class AbstractCalendarService
extends AbstractScheduleService {
    private static final String SCHEDULE = "schedule";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";

    protected AbstractCalendarService(String[] eventArchetypes, IArchetypeService service, EhcacheManager cacheManager, String cacheName, ScheduleEventFactory factory) {
        super(eventArchetypes, service, cacheManager, cacheName, factory);
    }

    public Times getOverlappingEvent(Act event) {
        Times result = null;
        IMObjectBean bean = this.getService().getBean((IMObject)event);
        Reference schedule = bean.getTargetRef(SCHEDULE);
        Times times = Times.create(event);
        if (schedule != null && times != null) {
            result = this.getOverlappingEvent(times, schedule);
        }
        return result;
    }

    public Times getOverlappingEvent(Times times, Reference schedule) {
        Times result = null;
        Date startTime = times.getStartTime();
        Date endTime = times.getEndTime();
        Date fromDay = DateRules.getDate(startTime);
        Date toDay = DateRules.getDate(endTime);
        boolean incomplete = false;
        while (fromDay.compareTo(toDay) <= 0) {
            List<PropertySet> cached = this.getCached(schedule, fromDay);
            if (cached != null) {
                result = this.getOverlap(times, cached);
                if (result != null) {
                    break;
                }
            } else {
                incomplete = true;
            }
            fromDay = DateRules.getDate(fromDay, 1, DateUnits.DAYS);
        }
        if (result == null && incomplete) {
            List<Times> list = Collections.singletonList(times);
            result = this.getOverlap(list, schedule);
        }
        return result;
    }

    public Times getOverlappingEvent(List<Times> events, Entity schedule) {
        return this.getOverlappingEvent(events, schedule.getObjectReference());
    }

    public Times getOverlappingEvent(List<Times> events, Reference schedule) {
        Times result = events.isEmpty() ? null : (events.size() == 1 ? this.getOverlappingEvent(events.get(0), schedule) : this.getOverlap(events, schedule));
        return result;
    }

    public List<Times> getOverlappingEvents(List<Times> events, Entity schedule, int limit) {
        ArrayList<Times> result = new ArrayList<Times>();
        ObjectSetQueryIterator iterator = this.createOverlappingEventIterator(events, schedule.getObjectReference(), limit);
        while (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            result.add(this.createTimes(set));
        }
        return !result.isEmpty() ? result : null;
    }

    protected ObjectSetQueryIterator createOverlappingEventIterator(List<Times> events, Reference schedule, int maxResults) {
        return this.createOverlappingEventIterator(events, SCHEDULE, schedule, maxResults);
    }

    protected ObjectSetQueryIterator createOverlappingEventIterator(List<Times> events, String participationNode, Reference entity, int maxResults) {
        List<Long> ids = this.getIds(events);
        String[] archetypes = this.getEventArchetypes();
        ArchetypeQuery query = new ArchetypeQuery(archetypes, false, false);
        query.getArchetypeConstraint().setAlias("act");
        query.add((IConstraint)new ObjectRefSelectConstraint("act"));
        query.add((IConstraint)new NodeSelectConstraint(START_TIME));
        query.add((IConstraint)new NodeSelectConstraint(END_TIME));
        JoinConstraint participation = Constraints.join((String)participationNode);
        participation.add((IConstraint)Constraints.eq((String)"entity", (Reference)entity));
        OrConstraint participationActs = new OrConstraint();
        for (String archetype : archetypes) {
            participationActs.add((IConstraint)new ParticipationConstraint(ParticipationConstraint.Field.ActShortName, (Object)archetype));
        }
        participation.add((IConstraint)participationActs);
        query.add((IConstraint)participation);
        if (!ids.isEmpty()) {
            query.add((IConstraint)Constraints.not((IConstraint)Constraints.in((String)"id", (Object[])ids.toArray())));
        }
        OrConstraint or = new OrConstraint();
        OrConstraint participationTimes = new OrConstraint();
        for (Times times : events) {
            Date startTime = times.getStartTime();
            if (times.isInstant()) {
                or.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.lte((String)START_TIME, (Object)startTime), Constraints.gt((String)END_TIME, (Object)startTime)}));
                participationTimes.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.LTE, (Object)startTime), new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.GT, (Object)startTime)}));
                continue;
            }
            Date endTime = times.getEndTime();
            or.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{Constraints.lt((String)START_TIME, (Object)endTime), Constraints.gt((String)END_TIME, (Object)startTime)}));
            participationTimes.add((IConstraint)Constraints.and((IConstraint[])new IConstraint[]{new ParticipationConstraint(ParticipationConstraint.Field.StartTime, RelationalOp.LT, (Object)endTime), new ParticipationConstraint(ParticipationConstraint.Field.EndTime, RelationalOp.GT, (Object)startTime)}));
        }
        participation.add((IConstraint)participationTimes);
        query.add((IConstraint)or);
        query.add((IConstraint)Constraints.sort((String)START_TIME));
        query.setMaxResults(maxResults);
        IArchetypeService service = this.getService();
        return new ObjectSetQueryIterator(service, (IArchetypeQuery)query);
    }

    protected Times createTimes(ObjectSet set) {
        return new Times((Reference)set.getReference("act.reference"), set.getDate("act.startTime"), set.getDate("act.endTime"));
    }

    private Times getOverlap(List<Times> events, Reference schedule) {
        Times result = null;
        ObjectSetQueryIterator iterator = this.createOverlappingEventIterator(events, schedule, 1);
        if (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            result = this.createTimes(set);
        }
        return result;
    }

    private List<Long> getIds(List<Times> events) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Times times : events) {
            if (times.getId() == -1L) continue;
            ids.add(times.getId());
        }
        return ids;
    }

    private Times getOverlap(Times times, List<PropertySet> events) {
        Times result = null;
        boolean isNew = times.getId() == -1L;
        for (PropertySet event : events) {
            Date endTime2;
            Date startTime2;
            IMObjectReference ref = event.getReference("act.objectReference");
            if (!isNew && ref.getId() == times.getId() || !times.intersects(startTime2 = event.getDate("act.startTime"), endTime2 = event.getDate("act.endTime"))) continue;
            result = new Times((Reference)ref, startTime2, endTime2);
            break;
        }
        return result;
    }
}

