/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier.account;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openvpms.archetype.rules.supplier.account.SupplierActReversalHandler;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class SupplierAccountRules {
    private final IArchetypeService service;

    public SupplierAccountRules(IArchetypeService service) {
        this.service = service;
    }

    public BigDecimal getBalance(Party supplier) {
        BigDecimal result = BigDecimal.ZERO;
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("supplierId", supplier.getId());
        NamedQuery query = new NamedQuery("getSupplierAccountBalance", Collections.singletonList("balance"), parameters);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        if (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            result = set.getBigDecimal("balance", BigDecimal.ZERO);
        }
        return result;
    }

    public FinancialAct reverse(FinancialAct act, Date startTime) {
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new SupplierActReversalHandler((Act)act), (ArchetypeService)this.service);
        List objects = copier.apply((IMObject)act);
        FinancialAct reversal = (FinancialAct)objects.get(0);
        reversal.setStatus("POSTED");
        reversal.setActivityStartTime(startTime);
        this.service.save((Collection)objects);
        return reversal;
    }
}

