/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.i18n.ArchetypeMessages;
import org.openvpms.archetype.rules.act.ActStatusHelper;
import org.openvpms.archetype.rules.math.Currencies;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.PriceCollector;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ProductPriceUpdater;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.supplier.DeliveryProcessorException;
import org.openvpms.archetype.rules.supplier.DeliveryStatus;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class DeliveryProcessor {
    private final Map<Reference, FinancialAct> orders = new HashMap<Reference, FinancialAct>();
    private final Map<Reference, DeliveryStatus> statuses = new HashMap<Reference, DeliveryStatus>();
    private final Act act;
    private final ProductRules rules;
    private final ArchetypeService service;
    private final ProductPriceUpdater priceUpdater;
    private final boolean ignoreListPriceDecreases;
    private final Set<IMObject> toSave = new LinkedHashSet<IMObject>();
    private Party supplier;
    private Party stockLocation;
    private String notes;
    private static final String QUANTITY = "quantity";
    private static final String RECEIVED_QUANTITY = "receivedQuantity";
    private static final String PACKAGE_SIZE = "packageSize";
    private static final String STOCK_LOCATION = "stockLocation";

    public DeliveryProcessor(Act act, IArchetypeService service, Currencies currencies, LookupService lookups) {
        this.act = act;
        this.service = service;
        this.rules = new ProductRules(service, lookups);
        ProductPriceRules priceRules = new ProductPriceRules((ArchetypeService)service);
        PracticeRules practiceRules = new PracticeRules((ArchetypeService)service, currencies);
        this.priceUpdater = new ProductPriceUpdater(priceRules, practiceRules, service);
        this.ignoreListPriceDecreases = practiceRules.ignoreListPriceDecreases(this.priceUpdater.getPractice());
    }

    public void apply() {
        if ("POSTED".equals(this.act.getStatus()) && !ActStatusHelper.isPosted(this.act, this.service)) {
            IMObjectBean bean = this.service.getBean((IMObject)this.act);
            this.supplier = (Party)bean.getTarget("supplier", Party.class);
            this.stockLocation = (Party)bean.getTarget(STOCK_LOCATION, Party.class);
            for (Act act : bean.getTargets("items", Act.class)) {
                this.processItem(act);
            }
            for (Act act : this.orders.values()) {
                this.updateDeliveryStatus(act);
            }
            if (!this.toSave.isEmpty()) {
                this.service.save(this.toSave);
            }
        }
    }

    public static DeliveryStatus getDeliveryStatus(FinancialAct orderItem, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)orderItem);
        BigDecimal quantity = bean.getBigDecimal(QUANTITY, BigDecimal.ZERO);
        BigDecimal received = bean.getBigDecimal(RECEIVED_QUANTITY, BigDecimal.ZERO);
        BigDecimal cancelled = bean.getBigDecimal("cancelledQuantity", BigDecimal.ZERO);
        return DeliveryStatus.getStatus(quantity, received, cancelled);
    }

    private void processItem(Act item) {
        Product product;
        IMObjectBean itemBean = this.service.getBean((IMObject)item);
        BigDecimal receivedQuantity = itemBean.getBigDecimal(QUANTITY);
        int receivedPackSize = itemBean.getInt(PACKAGE_SIZE);
        boolean delivery = this.act.isA("act.supplierDelivery");
        if (!delivery) {
            receivedQuantity = receivedQuantity.negate();
        }
        if ((product = (Product)itemBean.getTarget("product", Product.class)) == null) {
            throw new DeliveryProcessorException(DeliveryProcessorException.ErrorCode.NoProduct, DescriptorHelper.getDisplayName((IMObject)item, (ArchetypeService)this.service), item.getId(), DescriptorHelper.getDisplayName((IMObject)this.act, (ArchetypeService)this.service), this.act.getId());
        }
        for (FinancialAct orderItem : itemBean.getTargets("order", FinancialAct.class)) {
            this.updateReceivedQuantity(orderItem, receivedQuantity, receivedPackSize);
        }
        if (delivery) {
            if (this.supplier != null) {
                this.updateProductSupplier(product, itemBean);
            }
            String batchNumber = StringUtils.trimToNull((String)itemBean.getString("batchNumber"));
            Date expiryDate = itemBean.getDate("expiryDate");
            Reference manufacturer = itemBean.getTargetRef("manufacturer");
            if (batchNumber != null || expiryDate != null) {
                this.updateBatch(product, batchNumber, expiryDate, manufacturer);
            }
        }
        if (this.stockLocation != null) {
            this.updateStockQuantity(product, this.stockLocation, receivedQuantity, receivedPackSize);
        }
    }

    private void updateBatch(Product product, String batchNumber, Date expiryDate, Reference manufacturer) {
        Reference productRef = product.getObjectReference();
        List<Entity> batches = this.rules.getBatches(productRef, batchNumber, expiryDate, manufacturer);
        if (batches.isEmpty()) {
            if (batchNumber == null) {
                batchNumber = product.getName();
            }
            if (!StringUtils.isEmpty((CharSequence)batchNumber)) {
                Entity batch = this.rules.createBatch(productRef, batchNumber, expiryDate, manufacturer);
                this.updateBatchLocation(batch);
                this.toSave.add((IMObject)batch);
            }
        } else {
            Entity batch = batches.get(0);
            if (this.updateBatchLocation(batch)) {
                this.toSave.add((IMObject)batch);
            }
        }
    }

    private boolean updateBatchLocation(Entity batch) {
        IMObjectBean bean = this.service.getBean((IMObject)batch);
        if (!bean.getTargetRefs("stockLocations").contains(this.stockLocation.getObjectReference())) {
            bean.addTarget("stockLocations", (IMObject)this.stockLocation);
            return true;
        }
        return false;
    }

    private void updateStockQuantity(Product product, Party stockLocation, BigDecimal quantity, int packageSize) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        if (bean.hasNode("stockLocations")) {
            Predicate predicate = Predicates.activeNow().and(Predicates.targetEquals((IMObject)stockLocation));
            Relationship relationship = (Relationship)bean.getValue("stockLocations", Relationship.class, predicate);
            if (relationship == null) {
                relationship = bean.addTarget("stockLocations", (IMObject)stockLocation);
                this.toSave.add((IMObject)product);
            } else {
                this.toSave.add((IMObject)relationship);
            }
            BigDecimal units = quantity.multiply(BigDecimal.valueOf(packageSize));
            IMObjectBean relBean = this.service.getBean((IMObject)relationship);
            BigDecimal stockQuantity = relBean.getBigDecimal(QUANTITY);
            stockQuantity = stockQuantity.add(units);
            if (stockQuantity.compareTo(BigDecimal.ZERO) < 0) {
                stockQuantity = BigDecimal.ZERO;
            }
            relBean.setValue(QUANTITY, (Object)stockQuantity);
        }
    }

    private void updateReceivedQuantity(FinancialAct orderItem, BigDecimal quantity, int packageSize) {
        IMObjectBean bean = this.service.getBean((IMObject)orderItem);
        BigDecimal received = bean.getBigDecimal(RECEIVED_QUANTITY);
        BigDecimal cancelled = bean.getBigDecimal("cancelledQuantity");
        BigDecimal orderQuantity = orderItem.getQuantity();
        DeliveryStatus oldStatus = DeliveryStatus.getStatus(orderQuantity, received, cancelled);
        int orderedPackSize = bean.getInt(PACKAGE_SIZE);
        if (packageSize != orderedPackSize && orderedPackSize != 0) {
            quantity = quantity.multiply(BigDecimal.valueOf(packageSize));
            quantity = MathRules.divide(quantity, orderedPackSize, 3);
        }
        if ((received = received.add(quantity)).compareTo(BigDecimal.ZERO) < 0) {
            received = BigDecimal.ZERO;
        }
        bean.setValue(RECEIVED_QUANTITY, (Object)received);
        this.toSave.add((IMObject)orderItem);
        DeliveryStatus newStatus = DeliveryStatus.getStatus(orderQuantity, received, cancelled);
        this.statuses.put(orderItem.getObjectReference(), newStatus);
        if (oldStatus != newStatus) {
            this.loadOrder(bean);
        }
    }

    private void updateDeliveryStatus(Act order) {
        IMObjectBean bean = this.service.getBean((IMObject)order);
        DeliveryStatus current = DeliveryStatus.valueOf(order.getStatus2());
        DeliveryStatus newStatus = null;
        boolean pending = false;
        boolean part = false;
        boolean full = false;
        for (ActRelationship relationship : bean.getValues("items", ActRelationship.class)) {
            Reference target = relationship.getTarget();
            DeliveryStatus status = this.getDeliveryStatus(target);
            if (status == DeliveryStatus.PART) {
                part = true;
                break;
            }
            if (status == DeliveryStatus.FULL) {
                full = true;
                continue;
            }
            pending = true;
        }
        if (part || pending && full) {
            newStatus = DeliveryStatus.PART;
        } else if (!pending && full) {
            newStatus = DeliveryStatus.FULL;
        } else if (pending) {
            newStatus = DeliveryStatus.PENDING;
        }
        if (newStatus != null && newStatus != current) {
            order.setStatus2(newStatus.toString());
            this.toSave.add((IMObject)order);
        }
    }

    private DeliveryStatus getDeliveryStatus(Reference ref) {
        FinancialAct item;
        DeliveryStatus result = null;
        if (ref != null && (result = this.statuses.get(ref)) == null && (item = this.getAct(ref)) != null) {
            result = DeliveryProcessor.getDeliveryStatus(item, this.service);
        }
        return result;
    }

    private void loadOrder(IMObjectBean bean) {
        FinancialAct order;
        Reference ref = bean.getSourceRef("order");
        if (ref != null && (order = this.orders.get(ref)) == null && (order = this.getAct(ref)) != null) {
            this.orders.put(ref, order);
        }
    }

    private FinancialAct getAct(Reference ref) {
        return ref != null ? (FinancialAct)this.service.get(ref, FinancialAct.class) : null;
    }

    private void updateProductSupplier(Product product, IMObjectBean deliveryItemBean) {
        int size = deliveryItemBean.getInt(PACKAGE_SIZE);
        String units = deliveryItemBean.getString("packageUnits");
        String reorderCode = deliveryItemBean.getString("reorderCode");
        String reorderDesc = deliveryItemBean.getString("reorderDescription");
        BigDecimal listPrice = deliveryItemBean.getBigDecimal("listPrice");
        BigDecimal nettPrice = deliveryItemBean.getBigDecimal("unitPrice");
        ProductSupplier ps = this.rules.getProductSupplier(product, this.supplier, reorderCode, size, units);
        boolean save = true;
        if (ps == null) {
            ps = this.rules.createProductSupplier(product, this.supplier);
            ps.setPackageSize(size);
            ps.setPackageUnits(units);
            ps.setReorderCode(reorderCode);
            ps.setReorderDescription(reorderDesc);
            ps.setListPrice(listPrice);
            ps.setNettPrice(nettPrice);
            boolean preferred = this.rules.getPreferredSupplier(product) == null;
            ps.setPreferred(preferred);
        } else if (!(size == ps.getPackageSize() && Objects.equals(units, ps.getPackageUnits()) && MathRules.equals(listPrice, ps.getListPrice()) && MathRules.equals(nettPrice, ps.getNettPrice()) && Objects.equals(ps.getReorderCode(), reorderCode) && Objects.equals(ps.getReorderDescription(), reorderDesc))) {
            ps.setPackageSize(size);
            ps.setPackageUnits(units);
            ps.setReorderCode(reorderCode);
            ps.setReorderDescription(reorderDesc);
            ps.setListPrice(listPrice);
            ps.setNettPrice(nettPrice);
        } else {
            save = false;
        }
        if (ps.isAutoPriceUpdate() && this.supplier.isActive()) {
            this.updateUnitPrices(product, ps);
        }
        if (save) {
            this.toSave.add((IMObject)ps.getRelationship());
        }
    }

    private void updateUnitPrices(Product product, ProductSupplier productSupplier) {
        PriceCollector collector = new PriceCollector(this.service);
        this.priceUpdater.update(product, productSupplier, this.ignoreListPriceDecreases, collector);
        for (ProductPrice price : collector.getPrices()) {
            if (!price.isNew()) continue;
            IMObjectBean bean = this.service.getBean((IMObject)price);
            bean.setValue("notes", (Object)this.getUnitPriceNotes());
        }
        this.toSave.addAll(collector.prepareSave());
    }

    private String getUnitPriceNotes() {
        if (this.notes == null) {
            this.notes = ArchetypeMessages.priceCreatedByDelivery(this.act, this.supplier).getMessage();
        }
        return this.notes;
    }
}

