/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock.io;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.csv.AbstractCSVReader;
import org.openvpms.archetype.csv.CSVException;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.stock.io.StockCSVWriter;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.archetype.rules.stock.io.StockDataSet;
import org.openvpms.component.model.document.Document;

public class StockCSVReader
extends AbstractCSVReader {
    private static final int LOCATION_ID = 0;
    private static final int LOCATION_NAME = 1;
    private static final int PRODUCT_ID = 2;
    private static final int PRODUCT_NAME = 3;
    private static final int SELLING_UNITS = 4;
    private static final int QUANTITY = 5;
    private static final int NEW_QUANTITY = 6;

    public StockCSVReader(DocumentHandlers handlers, char separator) {
        super(handlers, StockCSVWriter.HEADER, separator);
    }

    public StockDataSet read(Document document) {
        ArrayList<StockData> data = new ArrayList<StockData>();
        ArrayList<StockData> errors = new ArrayList<StockData>();
        StockDataSet result = new StockDataSet(data, errors);
        List<String[]> lines = this.readLines(document);
        int lineNo = 2;
        for (String[] line : lines) {
            this.parse(line, data, errors, lineNo);
            ++lineNo;
        }
        return result;
    }

    private void parse(String[] line, List<StockData> data, List<StockData> errors, int lineNo) {
        long stockLocationId = -1L;
        String stockLocationName = null;
        long productId = -1L;
        String productName = null;
        String sellingUnits = null;
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal newQuantity = BigDecimal.ZERO;
        try {
            this.checkFields(line, lineNo);
            stockLocationId = this.getLong(line, 0, lineNo, true);
            stockLocationName = this.getString(line, 1, lineNo, true);
            productId = this.getLong(line, 2, lineNo, true);
            productName = this.getString(line, 3, lineNo, true);
            sellingUnits = this.getString(line, 4, lineNo, false);
            quantity = this.getDecimal(line, 5, lineNo, true);
            newQuantity = this.getDecimal(line, 6, lineNo, true);
            data.add(new StockData(stockLocationId, stockLocationName, productId, productName, sellingUnits, quantity, newQuantity, lineNo));
        }
        catch (CSVException exception) {
            StockData invalid = new StockData(stockLocationId, stockLocationName, productId, productName, sellingUnits, quantity, newQuantity, lineNo);
            invalid.setError(exception.getMessage());
            errors.add(invalid);
        }
    }
}

