/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.util.List;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductUpdater;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ProductImporter {
    private final IArchetypeService service;
    private final ProductUpdater updater;

    public ProductImporter(ProductPriceRules rules, IArchetypeService service) {
        this.service = service;
        this.updater = new ProductUpdater(rules, (ArchetypeService)service);
    }

    public void run(List<ProductData> products) {
        for (ProductData data : products) {
            Product product = (Product)this.service.get(data.getReference());
            if (product == null) continue;
            this.updater.update(product, data);
            this.service.save((IMObject)product);
        }
    }
}

