/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.Date;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ServiceRatio;
import org.openvpms.archetype.rules.workflow.CalendarService;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class ServiceRatioService {
    private final CalendarService calendarService;
    private final ProductPriceRules rules;

    public ServiceRatioService(CalendarService calendarService, ProductPriceRules rules) {
        this.calendarService = calendarService;
        this.rules = rules;
    }

    public BigDecimal getServiceRatio(Product product, Entity department, Party location, Date date) {
        BigDecimal result = null;
        ServiceRatio ratio = this.rules.getServiceRatio(product, department, location);
        if (ratio != null) {
            Reference calendar = ratio.getCalendar();
            if (calendar != null) {
                Times times = new Times(date, date);
                Times event = this.calendarService.getOverlappingEvent(times, calendar);
                if (event != null) {
                    result = ratio.getRatio();
                }
            } else {
                result = ratio.getRatio();
            }
        }
        return result;
    }
}

