/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.patient.reminder.ReminderCount;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ReminderType {
    private final Entity reminderType;
    private final int defaultInterval;
    private final DateUnits defaultUnits;
    private final int cancelInterval;
    private final DateUnits cancelUnits;
    private final GroupBy groupBy;
    private final List<ReminderCount> counts = new ArrayList<ReminderCount>();
    private final List<Lookup> groups;
    private final boolean interactive;

    public ReminderType(Entity reminderType, ArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)reminderType);
        this.defaultInterval = bean.getInt("defaultInterval");
        this.defaultUnits = ReminderType.getDateUnits(bean, "defaultUnits", DateUnits.YEARS);
        this.cancelInterval = bean.getInt("cancelInterval");
        this.cancelUnits = ReminderType.getDateUnits(bean, "cancelUnits", DateUnits.YEARS);
        for (IMObject count : bean.getTargets("counts")) {
            this.counts.add(new ReminderCount(count, service));
        }
        if (!this.counts.isEmpty()) {
            this.counts.sort(Comparator.comparingInt(ReminderCount::getCount));
        }
        String group = bean.getString("groupBy");
        this.groupBy = GroupBy.CUSTOMER.name().equals(group) ? GroupBy.CUSTOMER : (GroupBy.PATIENT.name().equals(group) ? GroupBy.PATIENT : GroupBy.NONE);
        this.groups = bean.getValues("groups", Lookup.class);
        this.interactive = bean.getBoolean("interactive");
        this.reminderType = reminderType;
    }

    public Entity getEntity() {
        return this.reminderType;
    }

    public String getName() {
        return this.reminderType.getName();
    }

    public boolean isActive() {
        return this.reminderType.isActive();
    }

    public Date getDueDate(Date date) {
        return DateRules.getDate(date, this.defaultInterval, this.defaultUnits);
    }

    public Date getCancelDate(Date date) {
        return DateRules.getDate(date, this.cancelInterval, this.cancelUnits);
    }

    public boolean shouldCancel(Date dueDate, Date date) {
        Date cancelDate = this.getCancelDate(dueDate);
        return cancelDate.getTime() <= date.getTime();
    }

    public int getDefaultInterval() {
        return this.defaultInterval;
    }

    public DateUnits getDefaultUnits() {
        return this.defaultUnits;
    }

    public int getCancelInterval() {
        return this.cancelInterval;
    }

    public DateUnits getCancelUnits() {
        return this.cancelUnits;
    }

    public List<ReminderCount> getReminderCounts() {
        return this.counts;
    }

    public ReminderCount getReminderCount(int count) {
        return (ReminderCount)CollectionUtils.find(this.counts, object -> object.getCount() == count);
    }

    public Date getNextDueDate(Date dueDate, int reminderCount) {
        ReminderCount count = this.getReminderCount(reminderCount);
        return count != null ? count.getNextDueDate(dueDate) : null;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public List<Lookup> getGroups() {
        return this.groups;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    private static DateUnits getDateUnits(IMObjectBean bean, String node, DateUnits defaultUnits) {
        String units = bean.getString(node);
        return !StringUtils.isEmpty((CharSequence)units) ? DateUnits.valueOf(units) : defaultUnits;
    }

    public static enum GroupBy {
        CUSTOMER,
        PATIENT,
        NONE;

    }
}

