/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.prescription;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeSortConstraint;

public class PrescriptionRules {
    private final IArchetypeService service;

    public PrescriptionRules(IArchetypeService service) {
        this.service = service;
    }

    public boolean cancel(Act prescription) {
        boolean result = false;
        if (this.canDispense(prescription)) {
            prescription.setActivityEndTime(DateRules.getYesterday());
            this.service.save((IMObject)prescription);
            result = true;
        }
        return result;
    }

    public boolean canDispense(Act prescription) {
        boolean result = DateRules.compareDateToToday(prescription.getActivityEndTime()) >= 0 && this.getRemainingRepeats(prescription) > 0;
        return result;
    }

    public BigDecimal getQuantity(Act prescription) {
        IMObjectBean bean = this.service.getBean((IMObject)prescription);
        return bean.getBigDecimal("quantity", BigDecimal.ZERO);
    }

    public int getRepeats(Act prescription) {
        IMObjectBean bean = this.service.getBean((IMObject)prescription);
        return bean.getInt("repeats");
    }

    public int getDispensed(Act prescription) {
        IMObjectBean bean = this.service.getBean((IMObject)prescription);
        return bean.getValues("dispensing").size();
    }

    public int getRemainingRepeats(Act prescription) {
        return 1 + this.getRepeats(prescription) - this.getDispensed(prescription);
    }

    public Act getPrescription(Party patient, Product product) {
        return this.getPrescription(patient, product, Collections.emptyList());
    }

    public Act getPrescription(Party patient, Product product, List<Act> exclude) {
        return this.getPrescription(patient, product, new Date(), exclude);
    }

    public Act getPrescription(Party patient, Product product, Date expiryDate) {
        return this.getPrescription(patient, product, expiryDate, Collections.emptyList());
    }

    public Act getPrescription(Party patient, Product product, Date expiryDate, List<Act> exclude) {
        Act result = null;
        ArchetypeQuery query = new ArchetypeQuery("act.patientPrescription");
        query.add((IConstraint)Constraints.gte((String)"endTime", (Object)DateRules.getDate(expiryDate)));
        query.add((IConstraint)Constraints.join((String)"patient").add((IConstraint)Constraints.eq((String)"entity", (Object)patient)));
        query.add((IConstraint)Constraints.join((String)"product").add((IConstraint)Constraints.eq((String)"entity", (Object)product)));
        if (!exclude.isEmpty()) {
            for (Act act : exclude) {
                query.add((IConstraint)Constraints.ne((String)"id", (Object)act.getId()));
            }
        }
        query.add((IConstraint)new NodeSortConstraint("id"));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            Act act;
            act = (Act)iterator.next();
            if (this.getRemainingRepeats(act) <= 0) continue;
            result = act;
            break;
        }
        return result;
    }
}

