/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.party;

import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.contact.AddressFormatter;
import org.openvpms.archetype.rules.contact.BasicAddressFormatter;
import org.openvpms.archetype.rules.finance.account.AccountType;
import org.openvpms.archetype.rules.party.CustomerMerger;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderQuery;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class CustomerRules
extends PartyRules {
    public CustomerRules(IArchetypeService service, LookupService lookups) {
        this(service, lookups, new BasicAddressFormatter((ArchetypeService)service, lookups));
    }

    public CustomerRules(IArchetypeService service, LookupService lookups, AddressFormatter addressFormatter) {
        super(service, lookups, addressFormatter);
    }

    public Lookup getAccountTypeLookup(Party customer) {
        Lookup result = null;
        IMObjectBean bean = this.getArchetypeService().getBean((IMObject)customer);
        if (bean.hasNode("type")) {
            List types = bean.getValues("type", Lookup.class);
            result = types.isEmpty() ? null : (Lookup)types.get(0);
        }
        return result;
    }

    public AccountType getAccountType(Party customer) {
        Lookup lookup = this.getAccountTypeLookup(customer);
        return lookup != null ? new AccountType(lookup, (ArchetypeService)this.getArchetypeService()) : null;
    }

    public void mergeCustomers(Party from, Party to) {
        CustomerMerger merger = new CustomerMerger(this.getArchetypeService(), this);
        merger.merge(from, to);
    }

    public List<Act> getReminders(Party customer, int dueInterval, DateUnits dueUnits, boolean includeOverdue) {
        ReminderQuery query = new ReminderQuery(this.getArchetypeService());
        query.setCustomer(customer);
        Date from = new Date();
        Date to = DateRules.getDate(from, dueInterval, dueUnits);
        if (!includeOverdue) {
            query.setFrom(from);
        }
        query.setTo(to);
        query.setCustomer(customer);
        return query.execute();
    }
}

