/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.party;

import java.util.SortedMap;
import java.util.TreeMap;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;

public abstract class ContactMatcher {
    private final String[] shortNames;
    private final IMObjectBeanFactory factory;
    private final SortedMap<Integer, Contact> contacts = new TreeMap<Integer, Contact>();

    protected ContactMatcher(String shortName, IMObjectBeanFactory factory) {
        this(new String[]{shortName}, factory);
    }

    protected ContactMatcher(String[] shortNames, IMObjectBeanFactory factory) {
        this.shortNames = shortNames;
        this.factory = factory;
    }

    public boolean matches(Contact contact) {
        return this.isA(contact);
    }

    public boolean isA(Contact contact) {
        return contact.isA(this.shortNames);
    }

    public Contact getMatch() {
        Integer best = null;
        if (!this.contacts.isEmpty()) {
            best = this.contacts.firstKey();
        }
        return best != null ? (Contact)this.contacts.get(best) : null;
    }

    protected void setMatch(int priority, Contact contact) {
        this.contacts.putIfAbsent(priority, contact);
    }

    protected boolean isPreferred(Contact contact) {
        return this.isPreferred(this.factory.getBean((IMObject)contact));
    }

    protected boolean isPreferred(IMObjectBean bean) {
        return bean.hasNode("preferred") && bean.getBoolean("preferred");
    }

    protected IMObjectBean getBean(Contact contact) {
        return this.factory.getBean((IMObject)contact);
    }
}

