/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.tax;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openvpms.archetype.rules.finance.tax.TaxRuleException;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class CustomerTaxRules
extends TaxRules {
    private static final String[] CHARGE_ITEM_TYPES = new String[]{"act.customerAccountInvoiceItem", "act.customerAccountCreditItem", "act.customerAccountCounterItem"};
    private static final String[] ADJUSTMENT_TYPES = new String[]{"act.customerAccountBadDebt", "act.customerAccountCreditAdjust", "act.customerAccountDebitAdjust"};

    public CustomerTaxRules(Party practice, IArchetypeService service) {
        super(practice, (ArchetypeService)service);
    }

    public BigDecimal calculateTax(FinancialAct act) {
        BigDecimal tax = BigDecimal.ZERO;
        IMObjectBean bean = this.getService().getBean((IMObject)act);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        if (customer == null) {
            act.setTaxAmount((BigDecimal)Money.ZERO);
        } else {
            List<Lookup> taxRates = this.getTaxRates(act, customer);
            tax = this.calculateTaxAmount(act, taxRates);
        }
        return tax;
    }

    public BigDecimal calculateTax(FinancialAct act, Party customer) {
        List<Lookup> taxRates = this.getTaxRates(act, customer);
        return this.calculateTaxAmount(act, taxRates);
    }

    public List<Lookup> getTaxExemptions(Party customer) {
        IMObjectBean bean = this.getService().getBean((IMObject)customer);
        if (bean.hasNode("taxes")) {
            return bean.getValues("taxes", Lookup.class);
        }
        return Collections.emptyList();
    }

    public BigDecimal getTaxRate(Product product, Party customer) {
        List<Lookup> rates = this.getTaxRates(product, customer);
        return this.getTaxRate(rates);
    }

    public List<Lookup> getTaxRates(Product product, Party customer) {
        ArrayList<Lookup> rates = new ArrayList<Lookup>(this.getProductTaxRates(product));
        rates.removeAll(this.getTaxExemptions(customer));
        return rates;
    }

    private BigDecimal calculateTaxAmount(FinancialAct act, List<Lookup> taxRates) {
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal total = act.getTotal();
        if (total != null) {
            tax = this.calculateTax(total, taxRates, true);
        }
        act.setTaxAmount((BigDecimal)new Money(tax));
        return tax;
    }

    private List<Lookup> getTaxRates(FinancialAct act, Party customer) {
        Collection<Object> taxRates;
        IMObjectBean bean = this.getService().getBean((IMObject)act);
        if (bean.isA(CHARGE_ITEM_TYPES)) {
            Product product = (Product)bean.getTarget("product", Product.class);
            taxRates = product == null ? Collections.emptyList() : this.getProductTaxRates(product);
        } else if (bean.isA(ADJUSTMENT_TYPES)) {
            taxRates = this.getPracticeTaxRates();
        } else {
            throw new TaxRuleException(TaxRuleException.ErrorCode.InvalidActForTax, act.getArchetype());
        }
        ArrayList<Lookup> result = new ArrayList<Lookup>(taxRates);
        if (!result.isEmpty()) {
            List<Lookup> exclusions = this.getTaxExemptions(customer);
            result.removeAll(exclusions);
        }
        return result;
    }
}

