/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.order;

import org.openvpms.archetype.rules.finance.order.CustomerOrder;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public class CustomerPharmacyOrder
extends CustomerOrder {
    public CustomerPharmacyOrder(Party patient, Party customer, String note, Reference location, IArchetypeService service) {
        super(patient, customer, note, location, service);
    }

    public CustomerPharmacyOrder(Act act, IArchetypeService service) {
        super(act, TypeHelper.isA((IMObject)act, (String)"act.customerOrderPharmacy"), service);
    }

    public IMObjectBean getItem(Product product) {
        String archetype = this.hasOrder() ? "act.customerOrderItemPharmacy" : "act.customerReturnItemPharmacy";
        return this.getItem(archetype, product);
    }

    @Override
    public IMObjectBean createOrderItem() {
        return this.createItem("act.customerOrderItemPharmacy", this.getOrder());
    }

    @Override
    public IMObjectBean createReturnItem() {
        return this.createItem("act.customerReturnItemPharmacy", this.getReturn());
    }

    @Override
    protected IMObjectBean createOrder() {
        return this.createParent("act.customerOrderPharmacy");
    }

    @Override
    protected IMObjectBean createReturn() {
        return this.createParent("act.customerReturnPharmacy");
    }
}

