/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.invoice;

import java.util.Collections;
import java.util.List;
import org.openvpms.archetype.rules.product.DemographicUpdater;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

class DemographicUpdateHelper {
    private final IArchetypeService service;
    private final IMObjectBean itemBean;
    private IMObjectBean productBean;

    public DemographicUpdateHelper(Act item, IArchetypeService service) {
        this.itemBean = service.getBean((IMObject)item);
        Product product = (Product)this.itemBean.getTarget("product", Product.class);
        if (product != null) {
            this.productBean = service.getBean((IMObject)product);
        }
        this.service = service;
    }

    public DemographicUpdateHelper(IMObjectBean itemBean, IMObjectBean productBean, IArchetypeService service) {
        this.itemBean = itemBean;
        this.productBean = productBean;
        this.service = service;
    }

    public void processDemographicUpdates(Act invoice) {
        List<Lookup> updates;
        if ("POSTED".equals(invoice.getStatus()) && !(updates = this.getDemographicUpdates()).isEmpty()) {
            this.processDemographicUpdates(updates);
        }
    }

    public void processDemographicUpdates() {
        List<Lookup> updates = this.getDemographicUpdates();
        if (!updates.isEmpty() && this.invoicePosted()) {
            this.processDemographicUpdates(updates);
        }
    }

    private List<Lookup> getDemographicUpdates() {
        List updates = Collections.emptyList();
        if (this.productBean != null && this.productBean.hasNode("updates")) {
            updates = this.productBean.getValues("updates", Lookup.class);
        }
        return updates;
    }

    private boolean invoicePosted() {
        Reference reference = this.itemBean.getSourceRef("invoice");
        if (reference != null) {
            ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)new ObjectRefConstraint("act", reference));
            query.add((IConstraint)new NodeSelectConstraint("act.status"));
            query.add((IConstraint)new NodeConstraint("status", (Object)"POSTED"));
            query.setMaxResults(1);
            ObjectSetQueryIterator iter = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
            return iter.hasNext();
        }
        return false;
    }

    private void processDemographicUpdates(List<Lookup> updates) {
        DemographicUpdater updater = new DemographicUpdater(this.service);
        updater.evaluate(this.itemBean.getObject(), updates);
    }
}

