/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.invoice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ChargeItemEventLinker {
    private final ArchetypeService service;

    public ChargeItemEventLinker(ArchetypeService service) {
        this.service = service;
    }

    public void link(FinancialAct item, PatientHistoryChanges changes) {
        this.link(Collections.singletonList(item), changes);
    }

    public void link(Act event, Act item, PatientHistoryChanges changes) {
        this.link(event, Collections.singletonList(item), changes);
    }

    public void link(Act event, List<Act> items, PatientHistoryChanges changes) {
        this.prepare(event, items, changes);
        changes.save();
    }

    public void prepare(Act event, List<Act> items, PatientHistoryChanges changes) {
        for (Act item : items) {
            List<Act> acts = this.getActs(item, changes);
            changes.addToEvent(event, acts);
        }
    }

    public void prepare(Act event, Map<FinancialAct, List<Act>> items, PatientHistoryChanges changes) {
        for (Map.Entry<FinancialAct, List<Act>> entry : items.entrySet()) {
            ArrayList<Act> acts = new ArrayList<Act>();
            acts.add((Act)entry.getKey());
            acts.addAll((Collection)entry.getValue());
            changes.addToEvent(event, acts);
        }
    }

    public void link(List<FinancialAct> items, PatientHistoryChanges changes) {
        this.prepare(items, changes);
        changes.save();
    }

    public void prepare(List<FinancialAct> items, PatientHistoryChanges changes) {
        for (FinancialAct item : items) {
            List<Act> acts = this.getActs((Act)item, changes);
            Date startTime = item.getActivityStartTime();
            if (startTime == null) {
                startTime = new Date();
            }
            changes.addToEvents(acts, startTime);
        }
    }

    public void prepare(Map<FinancialAct, List<Act>> items, PatientHistoryChanges changes) {
        for (Map.Entry<FinancialAct, List<Act>> entry : items.entrySet()) {
            ArrayList<Act> acts = new ArrayList<Act>();
            FinancialAct item = entry.getKey();
            acts.add((Act)item);
            acts.addAll((Collection)entry.getValue());
            changes.addToEvents(acts, item.getActivityStartTime());
        }
    }

    public void prepareNotes(List<Act> notes, PatientHistoryChanges changes) {
        for (Act act : notes) {
            Date startTime = act.getActivityStartTime();
            if (startTime == null) {
                startTime = new Date();
            }
            changes.addToEvents(notes, startTime);
        }
    }

    private List<Act> getActs(Act item, PatientHistoryChanges changes) {
        ArrayList<Act> acts = new ArrayList<Act>();
        IMObjectBean bean = this.service.getBean((IMObject)item);
        acts.add(item);
        acts.addAll(this.getActs(bean, "dispensing", changes));
        acts.addAll(this.getActs(bean, "investigations", changes));
        acts.addAll(this.getActs(bean, "documents", changes));
        return acts;
    }

    private List<Act> getActs(IMObjectBean bean, String node, PatientHistoryChanges changes) {
        ArrayList<Act> result = new ArrayList<Act>();
        for (Reference ref : bean.getTargetRefs(node)) {
            Act act = (Act)changes.getObject(ref);
            if (act == null) continue;
            result.add(act);
        }
        return result;
    }
}

