/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRuleException;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class CustomerBalanceUpdater {
    private final IArchetypeService service;
    private final BalanceCalculator calculator;
    private final InsuranceRules rules;
    private static final String CUSTOMER = "customer";
    private static final String ACCOUNT_BALANCE = "accountBalance";

    public CustomerBalanceUpdater(IArchetypeService service) {
        this(service, null);
    }

    public CustomerBalanceUpdater(IArchetypeService service, InsuranceRules rules) {
        this.service = service;
        this.calculator = new BalanceCalculator(service);
        this.rules = rules;
    }

    public boolean hasAccountActs(Reference customer) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, CustomerAccountArchetypes.ACCOUNT_ACTS);
        query.setMaxResults(1);
        query.add((IConstraint)new NodeSelectConstraint("id"));
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return iterator.hasNext();
    }

    public void checkInitialBalance(FinancialAct initialBalance) {
        IMObjectBean bean;
        Reference customer;
        if (initialBalance.isNew() && (customer = (bean = this.service.getBean((IMObject)initialBalance)).getTargetRef(CUSTOMER)) != null && this.hasAccountActs(customer)) {
            throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.CannotCreateInitialBalance, new Object[0]);
        }
    }

    public void addToBalance(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (this.hasBalanceParticipation(bean)) {
            if (this.calculator.isAllocated(act)) {
                bean.removeValues(ACCOUNT_BALANCE);
            }
        } else if (!this.calculator.isAllocated(act)) {
            this.addBalanceParticipation(bean);
        }
    }

    public void updateBalance(FinancialAct act) {
        if ("POSTED".equals(act.getStatus())) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            if (this.hasBalanceParticipation(act)) {
                Reference customer = bean.getTargetRef(CUSTOMER);
                if (customer == null) {
                    throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.MissingCustomer, act);
                }
                this.updateBalance(act, customer);
            }
        }
    }

    public boolean inBalance(FinancialAct act) {
        boolean result = this.hasBalanceParticipation(act);
        if (!result) {
            result = this.calculator.isAllocated(act);
        }
        return result;
    }

    public List<FinancialAct> updateBalance(FinancialAct act, Iterator<FinancialAct> unallocated) {
        return this.updateBalance(act, unallocated, true);
    }

    public List<FinancialAct> updateBalance(FinancialAct act, Iterator<FinancialAct> unallocated, boolean save) {
        ArrayList<BalanceAct> debits = new ArrayList<BalanceAct>();
        ArrayList<BalanceAct> credits = new ArrayList<BalanceAct>();
        if (act != null && "POSTED".equals(act.getStatus())) {
            this.add(act, debits, credits);
        }
        while (unallocated.hasNext()) {
            FinancialAct a = unallocated.next();
            if (!"POSTED".equals(a.getStatus())) continue;
            this.add(a, debits, credits);
        }
        ArrayList<FinancialAct> modified = new ArrayList<FinancialAct>();
        for (BalanceAct credit : credits) {
            ListIterator iter = debits.listIterator();
            while (iter.hasNext()) {
                BalanceAct debit = (BalanceAct)iter.next();
                this.allocate(credit, debit);
                if (debit.isAllocated()) {
                    iter.remove();
                }
                if (!debit.isDirty()) continue;
                modified.add(debit.getAct());
            }
            if (!credit.isDirty()) continue;
            modified.add(credit.getAct());
        }
        if (save && !modified.isEmpty()) {
            this.service.save(modified);
        }
        return modified;
    }

    public Collection<FinancialAct> moveAllocations(FinancialAct act, FinancialAct reversal) {
        if (!"POSTED".equals(act.getStatus())) {
            throw new IllegalStateException("Cannot move allocations on act with status " + act.getStatus());
        }
        if (!"POSTED".equals(reversal.getStatus())) {
            throw new IllegalStateException("Cannot move allocations on act with status " + reversal.getStatus());
        }
        if (!MathRules.equals(act.getTotal(), reversal.getTotal())) {
            throw new IllegalStateException("Cannot move allocations: acts have different totals");
        }
        if (!MathRules.isZero(reversal.getAllocatedAmount())) {
            throw new IllegalStateException("Cannot move allocations: reversal should have no allocations");
        }
        HashMap<Reference, FinancialAct> changed = new HashMap<Reference, FinancialAct>();
        changed.put(act.getObjectReference(), act);
        changed.put(reversal.getObjectReference(), act);
        IMObjectBean source = this.service.getBean((IMObject)act);
        List allocations = source.getValues("allocation", ActRelationship.class);
        for (ActRelationship allocation : allocations) {
            Reference reference = act.getObjectReference().equals((Object)allocation.getSource()) ? allocation.getTarget() : allocation.getSource();
            FinancialAct related = changed.computeIfAbsent(reference, r -> (FinancialAct)this.service.get(r, FinancialAct.class));
            if (related == null || !this.canMoveAllocation(related)) continue;
            IMObjectBean bean = this.service.getBean((IMObject)allocation);
            BigDecimal allocated = bean.getBigDecimal("allocatedAmount", BigDecimal.ZERO);
            this.subtractAllocation(act, allocated, allocation);
            this.subtractAllocation(related, allocated, allocation);
        }
        HashSet<FinancialAct> result = new HashSet<FinancialAct>(changed.values());
        result.addAll(this.updateBalance(act, Collections.singletonList(reversal).iterator(), false));
        return result;
    }

    protected void add(FinancialAct act, List<BalanceAct> debits, List<BalanceAct> credits) {
        BalanceAct balanceAct = new BalanceAct(act);
        if (!balanceAct.isAllocated()) {
            if (act.isCredit()) {
                if (act.getTotal().signum() != -1) {
                    credits.add(balanceAct);
                } else {
                    debits.add(balanceAct);
                }
            } else if (act.getTotal().signum() != -1) {
                debits.add(balanceAct);
            } else {
                credits.add(balanceAct);
            }
        }
    }

    protected Iterator<FinancialAct> getUnallocatedActs(Reference customer, Act exclude) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createUnallocatedQuery(customer, CustomerAccountArchetypes.DEBITS_CREDITS, exclude);
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    protected Predicate<FinancialAct> includes() {
        return this::include;
    }

    protected boolean include(FinancialAct act) {
        return !this.isInvoiceInGapClaim(act);
    }

    protected boolean canMoveAllocation(FinancialAct act) {
        return !this.isInvoiceInClaim(act);
    }

    private void subtractAllocation(FinancialAct act, BigDecimal allocated, ActRelationship relationship) {
        BigDecimal newAllocation = act.getAllocatedAmount().subtract(allocated);
        if (newAllocation.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalStateException("Cannot subtract allocation=" + allocated + " from allocatedAmount=" + act.getAllocatedAmount() + " on act=" + act.getId() + ": allocatedAmount would be less than zero");
        }
        if (newAllocation.compareTo(act.getTotal().abs()) > 0) {
            throw new IllegalStateException("Cannot assign allocatedAmount=" + newAllocation + " to act=" + act.getId() + ": allocatedAmount would be greater than total=" + act.getTotal());
        }
        act.setAllocatedAmount(newAllocation);
        act.removeActRelationship(relationship);
        this.addToBalance(act);
    }

    private boolean isInvoiceInGapClaim(FinancialAct act) {
        boolean result = false;
        if (this.rules != null && act.isA("act.customerAccountChargesInvoice")) {
            result = this.rules.hasCurrentGapClaims(act);
        }
        return result;
    }

    private boolean isInvoiceInClaim(FinancialAct act) {
        boolean result = false;
        if (this.rules != null && act.isA("act.customerAccountChargesInvoice")) {
            result = this.rules.isClaimed(act, true);
        }
        return result;
    }

    private void updateBalance(FinancialAct act, Reference customer) {
        Predicate<FinancialAct> includes = this.includes();
        if (includes.evaluate((Object)act)) {
            FinancialAct reverses;
            if (MathRules.isZero(act.getAllocatedAmount()) && (reverses = (FinancialAct)this.service.getBean((IMObject)act).getSource("reverses", FinancialAct.class)) != null && includes.evaluate((Object)reverses)) {
                this.service.save(this.moveAllocations(reverses, act));
            }
            if (!this.calculator.isAllocated(act)) {
                Iterator<FinancialAct> unallocated = this.getUnallocatedActs(customer, (Act)act);
                FilterIterator filtered = new FilterIterator(unallocated, includes);
                this.updateBalance(act, (Iterator<FinancialAct>)filtered);
            }
        }
    }

    private void addBalanceParticipation(IMObjectBean act) {
        Reference customer = act.getTargetRef(CUSTOMER);
        if (customer == null) {
            throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.MissingCustomer, act.getObject());
        }
        act.setTarget(ACCOUNT_BALANCE, customer);
    }

    private boolean hasBalanceParticipation(FinancialAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return this.hasBalanceParticipation(bean);
    }

    private boolean hasBalanceParticipation(IMObjectBean act) {
        return act.getTargetRef(ACCOUNT_BALANCE) != null;
    }

    private void allocate(BalanceAct credit, BalanceAct debit) {
        BigDecimal creditToAlloc = credit.getAllocatable();
        if (creditToAlloc.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal debitToAlloc = debit.getAllocatable();
            if (creditToAlloc.compareTo(debitToAlloc) <= 0) {
                debit.addAllocated(creditToAlloc);
                debit.addRelationship(credit, creditToAlloc);
                credit.addAllocated(creditToAlloc);
            } else {
                debit.addAllocated(debitToAlloc);
                debit.addRelationship(credit, debitToAlloc);
                credit.addAllocated(debitToAlloc);
            }
        }
    }

    class BalanceAct {
        private final FinancialAct act;
        private boolean dirty;

        BalanceAct(FinancialAct act) {
            this.act = act;
        }

        public void addRelationship(BalanceAct credit, BigDecimal allocated) {
            IMObjectBean debitBean = CustomerBalanceUpdater.this.service.getBean((IMObject)this.act);
            Relationship relationship = debitBean.addTarget("allocation", (IMObject)credit.getAct(), "allocation");
            IMObjectBean relBean = CustomerBalanceUpdater.this.service.getBean((IMObject)relationship);
            relBean.setValue("allocatedAmount", (Object)allocated);
        }

        public boolean isCredit() {
            return this.act.isCredit();
        }

        public FinancialAct getAct() {
            return this.act;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        BigDecimal getAllocatable() {
            return CustomerBalanceUpdater.this.calculator.getAllocatable(this.act);
        }

        boolean isAllocated() {
            return CustomerBalanceUpdater.this.calculator.isAllocated(this.act);
        }

        void addAllocated(BigDecimal allocated) {
            BigDecimal value = this.act.getAllocatedAmount().add(allocated);
            this.act.setAllocatedAmount(value);
            if (this.isAllocated()) {
                IMObjectBean bean = CustomerBalanceUpdater.this.service.getBean((IMObject)this.act);
                bean.removeValues(CustomerBalanceUpdater.ACCOUNT_BALANCE);
            }
            this.dirty = true;
        }
    }
}

