/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.JoinConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ParticipationConstraint;
import org.openvpms.component.system.common.query.RelationalOp;
import org.openvpms.component.system.common.query.ShortNameConstraint;

public class CustomerBalanceSummaryQuery
implements Iterator<ObjectSet> {
    public static final String CUSTOMER_REFERENCE = "customer.objectReference";
    public static final String CUSTOMER_NAME = "customer.name";
    public static final String BALANCE = "balance";
    public static final String OVERDUE_BALANCE = "overdueBalance";
    public static final String CREDIT_BALANCE = "creditBalance";
    public static final String LAST_PAYMENT_DATE = "lastPaymentDate";
    public static final String LAST_PAYMENT_AMOUNT = "lastPaymentAmount";
    public static final String LAST_INVOICE_DATE = "lastInvoiceDate";
    public static final String LAST_INVOICE_AMOUNT = "lastInvoiceAmount";
    public static final String UNBILLED_AMOUNT = "unbilledAmount";
    private final Date date;
    private final boolean nonOverdue;
    private final boolean overdue;
    private final boolean excludeCredit;
    private final IArchetypeService service;
    private final LookupService lookups;
    private final CustomerAccountRules rules;
    private final BalanceCalculator balanceCalc;
    private final ActCalculator calculator;
    private final int from;
    private final int to;
    private final Iterator<ObjectSet> iterator;
    private final Map<String, Lookup> lookupCache = new HashMap<String, Lookup>();
    private ObjectSet last;
    private ObjectSet next;
    private static final String[] CUSTOMERS = new String[]{"party.customerperson", "party.organisationOTC"};
    private static final Set<String> NAMES = new LinkedHashSet<String>();
    private static final String START_TIME = "a.startTime";
    private static final String STATUS = "a.status";

    public CustomerBalanceSummaryQuery(Date date, IArchetypeService service, LookupService lookups, CustomerAccountRules rules) {
        this(date, 0, 0, null, null, null, service, lookups, rules);
    }

    public CustomerBalanceSummaryQuery(Date date, Lookup accountType, IArchetypeService service, LookupService lookups, CustomerAccountRules rules) {
        this(date, accountType, null, null, service, lookups, rules);
    }

    public CustomerBalanceSummaryQuery(Date date, Lookup accountType, String customerFrom, String customerTo, IArchetypeService service, LookupService lookups, CustomerAccountRules rules) {
        this(date, accountType, customerFrom, customerTo, Location.ALL, service, lookups, rules);
    }

    public CustomerBalanceSummaryQuery(Date date, Lookup accountType, String customerFrom, String customerTo, Location location, IArchetypeService service, LookupService lookups, CustomerAccountRules rules) {
        this(date, true, 0, 0, false, accountType, customerFrom, customerTo, location, service, lookups, rules);
    }

    public CustomerBalanceSummaryQuery(Date date, int overdueFrom, int overdueTo, Lookup accountType, IArchetypeService service, LookupService lookups, CustomerAccountRules rules) {
        this(date, overdueFrom, overdueTo, accountType, null, null, service, lookups, rules);
    }

    public CustomerBalanceSummaryQuery(Date date, int overdueFrom, int overdueTo, Lookup accountType, String customerFrom, String customerTo, IArchetypeService service, LookupService lookups, CustomerAccountRules rules) {
        this(date, false, overdueFrom, overdueTo, false, accountType, customerFrom, customerTo, Location.ALL, service, lookups, rules);
    }

    public CustomerBalanceSummaryQuery(Date date, boolean nonOverdue, int overdueFrom, int overdueTo, boolean excludeCredit, Lookup accountType, String customerFrom, String customerTo, Location location, IArchetypeService service, LookupService lookups, CustomerAccountRules rules) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        this.date = calendar.getTime();
        this.excludeCredit = excludeCredit;
        this.nonOverdue = nonOverdue;
        this.service = service;
        this.lookups = lookups;
        this.overdue = overdueFrom >= 0 && overdueTo >= 0;
        this.from = overdueFrom;
        this.to = overdueTo;
        this.rules = rules;
        ArchetypeQuery query = this.createQuery(this.date, accountType, customerFrom, customerTo, location);
        query.setMaxResults(1000);
        this.iterator = new ObjectSetQueryIterator(service, (IArchetypeQuery)query);
        this.balanceCalc = new BalanceCalculator(service);
        this.calculator = new ActCalculator((ArchetypeService)service);
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            while (this.last != null || this.iterator.hasNext()) {
                this.next = this.doNext();
                if (this.next == null) continue;
            }
        }
        return this.next != null;
    }

    @Override
    public ObjectSet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ObjectSet result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private ArchetypeQuery createQuery(Date startTime, Lookup accountType, String customerFrom, String customerTo, Location location) {
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"a", CustomerAccountArchetypes.DEBITS_CREDITS));
        query.add((IConstraint)new NodeSelectConstraint("e.name"));
        query.add((IConstraint)new ObjectRefSelectConstraint("e"));
        query.add((IConstraint)new ObjectRefSelectConstraint("a"));
        query.add((IConstraint)new NodeSelectConstraint(START_TIME));
        query.add((IConstraint)new NodeSelectConstraint(STATUS));
        query.add((IConstraint)new NodeSelectConstraint("a.amount"));
        query.add((IConstraint)new NodeSelectConstraint("a.allocatedAmount"));
        query.add((IConstraint)new NodeSelectConstraint("a.credit"));
        query.add((IConstraint)new NodeSelectConstraint("c.code"));
        JoinConstraint participation = Constraints.join((String)"accountBalance");
        participation.add((IConstraint)new ParticipationConstraint(null, ParticipationConstraint.Field.StartTime, RelationalOp.LTE, (Object)startTime));
        JoinConstraint entity = Constraints.join((String)"entity", (String)"e");
        participation.add((IConstraint)entity);
        query.add((IConstraint)participation);
        if (location.getPracticeLocation() != null) {
            entity.add((IConstraint)Constraints.join((String)"practice").add((IConstraint)Constraints.eq((String)"target", (Reference)location.getPracticeLocation().getObjectReference())));
        } else if (location.isNone()) {
            query.add((IConstraint)Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String[])CUSTOMERS, (String)"c2").add((IConstraint)Constraints.join((String)"practice").add((IConstraint)Constraints.idEq((String)"e", (String)"c2")))));
        }
        entity.add((IConstraint)Constraints.leftJoin((String)"type", (String)"c"));
        query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.eq((String)STATUS, (Object)"POSTED"), Constraints.eq((String)STATUS, (Object)"COMPLETED")}));
        query.add((IConstraint)Constraints.lte((String)START_TIME, (Object)startTime));
        if (accountType != null) {
            query.add((IConstraint)Constraints.eq((String)"c.id", (Object)accountType.getId()));
        }
        if (!StringUtils.isEmpty((CharSequence)customerFrom)) {
            entity.add((IConstraint)Constraints.gte((String)"name", (Object)customerFrom.replace('*', '%')));
        }
        if (!StringUtils.isEmpty((CharSequence)customerTo)) {
            entity.add((IConstraint)Constraints.lte((String)"name", (Object)customerTo.replace('*', '%')));
        }
        query.add((IConstraint)Constraints.sort((String)"e", (String)"name"));
        query.add((IConstraint)Constraints.sort((String)"e", (String)"id"));
        query.add((IConstraint)Constraints.sort((String)"a", (String)"startTime"));
        return query;
    }

    private ObjectSet doNext() {
        Reference current = null;
        LinkedHashMap<Reference, ObjectSet> sets = new LinkedHashMap<Reference, ObjectSet>();
        if (this.last != null) {
            sets.put(this.getAct(this.last), this.last);
            current = this.getEntity(this.last);
            this.last = null;
        }
        while (this.iterator.hasNext()) {
            ObjectSet set = this.iterator.next();
            Reference party = this.getEntity(set);
            if (party == null) continue;
            if (current == null || current.equals((Object)party)) {
                current = party;
                sets.put(this.getAct(set), set);
                continue;
            }
            this.last = set;
            break;
        }
        if (sets.isEmpty()) {
            throw new NoSuchElementException();
        }
        String name = null;
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal overdueBalance = BigDecimal.ZERO;
        BigDecimal creditBalance = BigDecimal.ZERO;
        BigDecimal unbilled = BigDecimal.ZERO;
        Date overdueDate = null;
        Date overdueFrom = null;
        Date overdueTo = null;
        Lookup lookup = null;
        for (ObjectSet set : sets.values()) {
            name = set.getString("e.name");
            Date startTime = set.getDate(START_TIME);
            if (startTime instanceof Timestamp) {
                startTime = new Date(startTime.getTime());
            }
            String status = set.getString(STATUS);
            BigDecimal amount = set.getBigDecimal("a.amount");
            BigDecimal allocated = set.getBigDecimal("a.allocatedAmount");
            boolean credit = set.getBoolean("a.credit");
            if (amount.signum() == -1) {
                credit = !credit;
                amount = amount.negate();
            }
            if ("POSTED".equals(status)) {
                BigDecimal unallocated = this.balanceCalc.getAllocatable(amount, allocated);
                balance = this.calculator.addAmount(balance, unallocated, credit);
                String code = set.getString("c.code");
                if (code != null && lookup == null) {
                    lookup = this.getLookup(code);
                }
                if (overdueDate == null) {
                    overdueDate = lookup == null ? this.date : this.rules.getOverdueDate(lookup, this.date);
                    overdueFrom = overdueDate;
                    if (this.from > 0) {
                        overdueFrom = DateRules.getDate(overdueFrom, -this.from, DateUnits.DAYS);
                    }
                    if (this.to > 0) {
                        overdueTo = DateRules.getDate(overdueDate, -this.to, DateUnits.DAYS);
                    }
                }
                if (!(credit || startTime.compareTo(overdueFrom) >= 0 || overdueTo != null && startTime.compareTo(overdueTo) <= 0)) {
                    overdueBalance = this.calculator.addAmount(overdueBalance, unallocated, credit);
                }
                if (!credit) continue;
                creditBalance = this.calculator.addAmount(creditBalance, unallocated, credit);
                continue;
            }
            Reference act = this.getAct(set);
            if (!act.isA(new String[]{"act.customerAccountChargesInvoice", "act.customerAccountChargesCounter", "act.customerAccountChargesCredit"})) continue;
            unbilled = this.calculator.addAmount(unbilled, amount, credit);
        }
        if (overdueBalance.signum() < 0) {
            overdueBalance = BigDecimal.ZERO;
        }
        BalanceObjectSet result = null;
        boolean exclude = true;
        if (this.overdue && overdueBalance.compareTo(BigDecimal.ZERO) != 0) {
            exclude = false;
        }
        if (this.nonOverdue && overdueBalance.compareTo(BigDecimal.ZERO) == 0) {
            exclude = false;
        }
        if (this.excludeCredit && creditBalance.compareTo(BigDecimal.ZERO) != 0) {
            exclude = true;
        }
        if (!exclude) {
            result = new BalanceObjectSet(current);
            result.set(CUSTOMER_REFERENCE, current);
            result.set(CUSTOMER_NAME, name);
            result.set(BALANCE, balance);
            result.set(OVERDUE_BALANCE, overdueBalance);
            result.set(CREDIT_BALANCE, creditBalance);
            result.set(UNBILLED_AMOUNT, unbilled);
        }
        return result;
    }

    private Lookup getLookup(String code) {
        return this.lookupCache.computeIfAbsent(code, s -> this.lookups.getLookup("lookup.customerAccountType", code));
    }

    private Reference getEntity(ObjectSet set) {
        return set.getReference("e.reference");
    }

    private Reference getAct(ObjectSet set) {
        return set.getReference("a.reference");
    }

    static {
        NAMES.add(CUSTOMER_REFERENCE);
        NAMES.add(CUSTOMER_NAME);
        NAMES.add(BALANCE);
        NAMES.add(OVERDUE_BALANCE);
        NAMES.add(CREDIT_BALANCE);
        NAMES.add(LAST_PAYMENT_DATE);
        NAMES.add(LAST_PAYMENT_AMOUNT);
        NAMES.add(LAST_INVOICE_DATE);
        NAMES.add(LAST_INVOICE_AMOUNT);
        NAMES.add(UNBILLED_AMOUNT);
    }

    private class BalanceObjectSet
    extends ObjectSet {
        private final Reference customer;
        private boolean queriedLastPayment;
        private boolean queriedLastInvoice;

        public BalanceObjectSet(Reference customer) {
            this.customer = customer;
        }

        public Set<String> getNames() {
            return NAMES;
        }

        public Object get(String name) {
            Object object = null;
            if (!super.getNames().contains(name)) {
                if (CustomerBalanceSummaryQuery.LAST_PAYMENT_DATE.equals(name)) {
                    object = this.getLastPaymentDate();
                } else if (CustomerBalanceSummaryQuery.LAST_PAYMENT_AMOUNT.equals(name)) {
                    object = this.getLastPaymentAmount();
                } else if (CustomerBalanceSummaryQuery.LAST_INVOICE_DATE.equals(name)) {
                    object = this.getLastInvoiceDate();
                } else if (CustomerBalanceSummaryQuery.LAST_INVOICE_AMOUNT.equals(name)) {
                    object = this.getLastInvoiceAmount();
                }
            } else {
                object = super.get(name);
            }
            return object;
        }

        private Date getLastPaymentDate() {
            this.getLastPaymentDetails();
            return (Date)super.get(CustomerBalanceSummaryQuery.LAST_PAYMENT_DATE);
        }

        private BigDecimal getLastPaymentAmount() {
            this.getLastPaymentDetails();
            return (BigDecimal)super.get(CustomerBalanceSummaryQuery.LAST_PAYMENT_AMOUNT);
        }

        private void getLastPaymentDetails() {
            if (!this.queriedLastPayment) {
                this.queriedLastPayment = true;
                this.query("act.customerAccountPayment", CustomerBalanceSummaryQuery.LAST_PAYMENT_DATE, CustomerBalanceSummaryQuery.LAST_PAYMENT_AMOUNT);
            }
        }

        private Date getLastInvoiceDate() {
            this.getLastInvoiceDetails();
            return (Date)super.get(CustomerBalanceSummaryQuery.LAST_INVOICE_DATE);
        }

        private BigDecimal getLastInvoiceAmount() {
            this.getLastInvoiceDetails();
            return (BigDecimal)super.get(CustomerBalanceSummaryQuery.LAST_INVOICE_AMOUNT);
        }

        private void getLastInvoiceDetails() {
            if (!this.queriedLastInvoice) {
                this.queriedLastInvoice = true;
                this.query("act.customerAccountChargesInvoice", CustomerBalanceSummaryQuery.LAST_INVOICE_DATE, CustomerBalanceSummaryQuery.LAST_INVOICE_AMOUNT);
            }
        }

        private boolean query(String shortName, String dateKey, String amountKey) {
            boolean found = false;
            ShortNameConstraint archetype = new ShortNameConstraint("act", shortName);
            ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)archetype);
            query.add((IConstraint)Constraints.join((String)"customer").add((IConstraint)Constraints.eq((String)"entity", (Reference)this.customer)));
            query.add((IConstraint)new NodeSortConstraint("startTime", false));
            query.add((IConstraint)new NodeSelectConstraint("act.startTime"));
            query.add((IConstraint)new NodeSelectConstraint("act.amount"));
            query.setMaxResults(1);
            ObjectSetQueryIterator iter = new ObjectSetQueryIterator(CustomerBalanceSummaryQuery.this.service, (IArchetypeQuery)query);
            if (iter.hasNext()) {
                ObjectSet set = (ObjectSet)iter.next();
                this.set(dateKey, set.get("act.startTime"));
                this.set(amountKey, set.get("act.amount"));
                found = true;
            } else {
                this.set(dateKey, null);
                this.set(amountKey, null);
            }
            return found;
        }
    }
}

