/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerBalanceUpdater;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.CollectionNodeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefNodeConstraint;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class CustomerBalanceGenerator {
    private final Party customer;
    private final IArchetypeService service;
    private final CustomerBalanceUpdater updater;
    private final PlatformTransactionManager transactionManager;
    private final Iterator<FinancialAct> iterator;
    private final List<FinancialAct> unallocated = new ArrayList<FinancialAct>();
    private final Map<FinancialAct, Long> modified = new HashMap<FinancialAct, Long>();
    private int acts;

    public CustomerBalanceGenerator(Party customer, IArchetypeService service, CustomerBalanceUpdater updater, PlatformTransactionManager transactionManager) {
        this.customer = customer;
        this.service = service;
        this.updater = updater;
        this.transactionManager = transactionManager;
        this.iterator = this.getActs(customer);
    }

    public BigDecimal generate() {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        return (BigDecimal)template.execute(status -> this.doGenerate());
    }

    public int getModified() {
        return this.modified.size();
    }

    public int getProcessed() {
        return this.acts;
    }

    protected BigDecimal doGenerate() {
        FinancialAct act;
        ActCalculator calculator = new ActCalculator((ArchetypeService)this.service);
        BigDecimal runningTotal = BigDecimal.ZERO;
        while ((act = this.getNext()) != null) {
            if (act.isA(new String[]{"act.customerAccountOpeningBalance", "act.customerAccountClosingBalance"})) {
                BigDecimal total = calculator.getTotal(act);
                boolean credit = act.isA("act.customerAccountClosingBalance");
                BigDecimal expectedTotal = runningTotal;
                boolean expectedCredit = credit;
                if (runningTotal.signum() == -1) {
                    expectedTotal = runningTotal.negate();
                    boolean bl = expectedCredit = !credit;
                }
                if (MathRules.equals(total.abs(), expectedTotal) && act.isCredit() == expectedCredit) continue;
                act.setTotal(expectedTotal);
                act.setCredit(expectedCredit);
                this.modified(act);
                this.changed(act, total, runningTotal);
                continue;
            }
            this.addToBalance(act);
            if (!"POSTED".equals(act.getStatus())) continue;
            runningTotal = calculator.addAmount(runningTotal, act.getTotal(), act.isCredit());
        }
        this.save();
        return runningTotal;
    }

    protected Party getCustomer() {
        return this.customer;
    }

    protected void changed(FinancialAct act, BigDecimal fromTotal, BigDecimal toTotal) {
    }

    private void addToBalance(FinancialAct act) {
        IMObjectBean bean;
        BigDecimal allocated = act.getAllocatedAmount();
        if (allocated == null || allocated.compareTo(BigDecimal.ZERO) != 0) {
            act.setAllocatedAmount(BigDecimal.ZERO);
            this.modified(act);
        }
        if (act.getTotal() == null) {
            act.setTotal(BigDecimal.ZERO);
            this.modified(act);
        }
        if (!(bean = this.service.getBean((IMObject)act)).removeValues("accountBalance").isEmpty()) {
            this.modified(act);
        }
        if (!bean.removeValues("allocation").isEmpty()) {
            this.modified(act);
        }
        if (!this.updater.inBalance(act)) {
            this.updater.addToBalance(act);
            this.modified(act);
        }
    }

    private FinancialAct getNext() {
        if (this.iterator.hasNext()) {
            ++this.acts;
            return this.iterator.next();
        }
        return null;
    }

    private void modified(FinancialAct act) {
        if (this.modified.put(act, act.getVersion()) == null && act.isA(CustomerAccountArchetypes.DEBITS_CREDITS)) {
            this.unallocated.add(act);
        }
    }

    private void save() {
        HashSet<FinancialAct> unsaved = new HashSet<FinancialAct>(this.modified.keySet());
        if (!this.unallocated.isEmpty()) {
            List<FinancialAct> updated = this.updater.updateBalance(null, this.unallocated.iterator());
            unsaved.removeAll(updated);
        }
        if (!unsaved.isEmpty()) {
            this.service.save(unsaved);
        }
    }

    private Iterator<FinancialAct> getActs(Party customer) {
        ArchetypeQuery query = new ArchetypeQuery(CustomerAccountArchetypes.ACCOUNT_ACTS, true, true);
        CollectionNodeConstraint constraint = new CollectionNodeConstraint("customer", "participation.customer", true, true);
        constraint.add((IConstraint)new ObjectRefNodeConstraint("entity", customer.getObjectReference()));
        query.add((IConstraint)constraint);
        query.add((IConstraint)new NodeSortConstraint("startTime", true));
        query.add((IConstraint)new NodeSortConstraint("id", true));
        query.setMaxResults(1000);
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }
}

