/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import org.openvpms.component.business.service.archetype.helper.AbstractIMObjectCopyHandler;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractActReversalHandler
extends AbstractIMObjectCopyHandler {
    private final boolean debit;
    private final String[][] shortNames;

    protected AbstractActReversalHandler(boolean debit, String[][] shortNames) {
        this.debit = debit;
        this.shortNames = shortNames;
    }

    public IMObject getObject(IMObject object, ArchetypeService service) {
        IMObject result;
        if (object instanceof Act || object instanceof ActRelationship || object instanceof Participation) {
            String shortName = this.getArchetype(object);
            result = service.create(shortName, IMObject.class);
        } else {
            result = object;
        }
        return result;
    }

    private String getArchetype(IMObject object) {
        String shortName = object.getArchetype();
        for (String[] map : this.shortNames) {
            String debitType = map[0];
            String creditType = map[1];
            if (this.debit) {
                if (!debitType.equals(shortName)) continue;
                shortName = creditType;
                break;
            }
            if (!creditType.equals(shortName)) continue;
            shortName = debitType;
            break;
        }
        return shortName;
    }
}

