/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.net.URL;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.doc.ImageService;
import org.openvpms.archetype.rules.doc.LogoCache;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.entity.Entity;
import org.springframework.beans.factory.DisposableBean;

public class LogoService
implements DisposableBean {
    private final ImageService imageService;
    private final LogoCache cache;

    public LogoService(ImageService imageService, IArchetypeService service, DocumentRules rules) {
        this(imageService, service, rules, true);
    }

    public LogoService(ImageService imageService, IArchetypeService service, DocumentRules rules, boolean load) {
        this.imageService = imageService;
        this.cache = new LogoCache(service, rules, load);
    }

    public ImageService.Image getImage(Entity entity) {
        DocumentAct logo = this.getLogo(entity);
        return logo != null ? this.imageService.getImage(logo) : null;
    }

    public URL getURL(Entity entity) {
        DocumentAct act = this.getLogo(entity);
        return act != null ? this.getURL(act) : null;
    }

    public URL getURL(DocumentAct act) {
        return this.imageService.getURL(act);
    }

    public DocumentAct getLogo(Entity entity) {
        return this.cache.getLogo(entity);
    }

    public void destroy() {
        this.cache.destroy();
    }
}

