/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.i18n.time;

import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.openvpms.archetype.i18n.time.DurationFormatter;

public class DateDurationFormatter
implements DurationFormatter {
    public static final DurationFormatter YEAR;
    public static final DurationFormatter MONTH;
    public static final DurationFormatter WEEK;
    public static final DurationFormatter DAY;
    private final boolean showYears;
    private final boolean showMonths;
    private final boolean showWeeks;
    private final boolean showDays;
    private final boolean showHours;
    private final boolean showMinutes;
    private final PeriodFormatter formatter;
    private static final String MINUTE_SUFFIX;
    private static final String MINUTES_SUFFIX;
    private static final String HOUR_SUFFIX;
    private static final String HOURS_SUFFIX;
    private static final String DAY_SUFFIX;
    private static final String DAYS_SUFFIX;
    private static final String WEEK_SUFFIX;
    private static final String WEEKS_SUFFIX;
    private static final String MONTH_SUFFIX;
    private static final String MONTHS_SUFFIX;
    private static final String YEAR_SUFFIX;
    private static final String YEARS_SUFFIX;

    protected DateDurationFormatter(boolean showYears, boolean showMonths, boolean showWeeks, boolean showDays) {
        this(showYears, showMonths, showWeeks, showDays, false, false);
    }

    protected DateDurationFormatter(boolean showYears, boolean showMonths, boolean showWeeks, boolean showDays, boolean showHours, boolean showMinutes) {
        this.showYears = showYears;
        this.showMonths = showMonths;
        this.showWeeks = showWeeks;
        this.showDays = showDays;
        this.showHours = showHours;
        this.showMinutes = showMinutes;
        PeriodFormatterBuilder builder = new PeriodFormatterBuilder();
        if (showYears) {
            builder = builder.appendYears().appendSuffix(YEAR_SUFFIX, YEARS_SUFFIX).appendSeparator(" ");
        }
        if (showMonths) {
            builder = builder.appendMonths().appendSuffix(MONTH_SUFFIX, MONTHS_SUFFIX).appendSeparator(" ");
        }
        if (showWeeks) {
            builder = builder.appendWeeks().appendSuffix(WEEK_SUFFIX, WEEKS_SUFFIX).appendSeparator(" ");
        }
        if (showDays) {
            builder = builder.appendDays().appendSuffix(DAY_SUFFIX, DAYS_SUFFIX).appendSeparator(" ");
        }
        if (showHours) {
            builder = builder.appendHours().appendSuffix(HOUR_SUFFIX, HOURS_SUFFIX).appendSeparator(" ");
        }
        if (showMinutes) {
            builder = builder.appendMinutes().appendSuffix(MINUTE_SUFFIX, MINUTES_SUFFIX).appendSeparator(" ");
        }
        this.formatter = builder.toFormatter();
    }

    public static DurationFormatter create(boolean showYears, boolean showMonths, boolean showWeeks, boolean showDays) {
        return DateDurationFormatter.create(showYears, showMonths, showWeeks, showDays, false, false);
    }

    public static DurationFormatter create(boolean showYears, boolean showMonths, boolean showWeeks, boolean showDays, boolean showHours, boolean showMinutes) {
        if (!(!showYears || showMonths || showWeeks || showDays || showHours || showMinutes)) {
            return YEAR;
        }
        if (!(showYears || !showMonths || showWeeks || showDays || showHours || showMinutes)) {
            return MONTH;
        }
        if (!(showYears || showMonths || !showWeeks || showDays || showHours || showMinutes)) {
            return WEEK;
        }
        if (!(showYears || showMonths || showWeeks || !showDays || showHours || showMinutes)) {
            return DAY;
        }
        return new DateDurationFormatter(showYears, showMonths, showWeeks, showDays, showHours, showMinutes);
    }

    @Override
    public String format(Date from, Date to) {
        return this.format(new DateTime(from.getTime()), new DateTime(to.getTime()));
    }

    protected String format(DateTime from, DateTime to) {
        int years = 0;
        int months = 0;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        DateTime start = from;
        if (this.showYears) {
            years = Years.yearsBetween((ReadableInstant)start, (ReadableInstant)to).getYears();
            start = start.plusYears(years);
        }
        if (this.showMonths) {
            months = Months.monthsBetween((ReadableInstant)start, (ReadableInstant)to).getMonths();
            start = start.plusMonths(months);
        }
        if (this.showWeeks) {
            weeks = Weeks.weeksBetween((ReadableInstant)start, (ReadableInstant)to).getWeeks();
            start = start.plusWeeks(weeks);
        }
        if (this.showDays) {
            days = Days.daysBetween((ReadableInstant)start, (ReadableInstant)to).getDays();
            start = start.plusDays(days);
        }
        if (this.showHours) {
            hours = Hours.hoursBetween((ReadableInstant)start, (ReadableInstant)to).getHours();
            start = start.plusHours(hours);
        }
        if (this.showMinutes) {
            minutes = Minutes.minutesBetween((ReadableInstant)start, (ReadableInstant)to).getMinutes();
        }
        Period period = new Period(years, months, weeks, days, hours, minutes, 0, 0);
        return this.formatter.print((ReadablePeriod)period);
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle(DurationFormatter.class.getName(), Locale.getDefault());
        HOUR_SUFFIX = " " + bundle.getString("hour");
        HOURS_SUFFIX = " " + bundle.getString("hours");
        MINUTE_SUFFIX = " " + bundle.getString("minute");
        MINUTES_SUFFIX = " " + bundle.getString("minutes");
        DAY_SUFFIX = " " + bundle.getString("day");
        DAYS_SUFFIX = " " + bundle.getString("days");
        WEEK_SUFFIX = " " + bundle.getString("week");
        WEEKS_SUFFIX = " " + bundle.getString("weeks");
        MONTH_SUFFIX = " " + bundle.getString("month");
        MONTHS_SUFFIX = " " + bundle.getString("months");
        YEAR_SUFFIX = " " + bundle.getString("year");
        YEARS_SUFFIX = " " + bundle.getString("years");
        YEAR = new DateDurationFormatter(true, false, false, false, false, false);
        MONTH = new DateDurationFormatter(false, true, false, false, false, false);
        WEEK = new DateDurationFormatter(false, false, true, false, false, false);
        DAY = new DateDurationFormatter(false, false, false, true, false, false);
    }
}

