/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.user;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.jxpath.Functions;
import org.openvpms.archetype.function.user.UserFunctions;
import org.openvpms.archetype.rules.doc.ImageService;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

public class CachingUserFunctions
extends UserFunctions {
    private final Map<String, String> cache;

    public CachingUserFunctions(UserRules userRules, ArchetypeService service, PracticeService practiceService, LookupService lookups, ImageService imageService, Functions functions, int cacheSize) {
        super(userRules, service, practiceService, lookups, imageService, functions);
        this.cache = Collections.synchronizedMap(new LRUMap(cacheSize));
    }

    @Override
    public String format(User user, String style) {
        String result = null;
        if (user != null) {
            String key = this.getKey(user.getId(), style);
            result = this.cache.computeIfAbsent(key, s -> CachingUserFunctions.super.format(user, style));
        }
        return result;
    }

    @Override
    public String formatById(long id, String style) {
        String key = this.getKey(id, style);
        return this.cache.computeIfAbsent(key, s -> CachingUserFunctions.super.formatById(id, style));
    }

    private String getKey(long id, String style) {
        return id + style;
    }
}

