/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.patient;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.function.Predicate;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.Function;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;
import org.openvpms.component.system.common.jxpath.FunctionHelper;

public class PatientFunctions
extends AbstractObjectFunctions {
    private final PatientRules patientRules;
    private final SupplierRules supplierRules;
    private final AppointmentRules appointmentRules;
    private final MedicalRecordRules recordRules;
    private final IArchetypeService service;
    private static final Policy<Participation> PATIENT_PARTICIPATION = Policies.any(Participation.class, (Predicate)Predicates.isA((String[])new String[]{"participation.patient"}));

    public PatientFunctions(PatientRules patientRules, SupplierRules supplierRules, AppointmentRules appointmentRules, MedicalRecordRules recordRules, IArchetypeService service) {
        super("patient");
        this.setObject((Object)this);
        this.patientRules = patientRules;
        this.appointmentRules = appointmentRules;
        this.supplierRules = supplierRules;
        this.recordRules = recordRules;
        this.service = service;
    }

    public String age(ExpressionContext context) {
        return this.age(context.getContextNodePointer().getValue());
    }

    public String age(Object patient) {
        Party p = this.getPatient(patient);
        return p != null ? this.patientRules.getPatientAge(p) : null;
    }

    public String age(Object patient, Date date) {
        Party p = this.getPatient(patient);
        if (p != null) {
            return date == null ? this.patientRules.getPatientAge(p) : this.patientRules.getPatientAge(p, date);
        }
        return null;
    }

    public Iterable<Act> alerts(ExpressionContext context) {
        return this.alerts(context.getContextNodePointer().getValue());
    }

    public Iterable<Act> alerts(Object patient) {
        Party p = this.getPatient(patient);
        return p != null ? this.patientRules.getAlerts(p) : Collections.emptyList();
    }

    public Iterable<Act> appointments(Object patient, int interval, String units) {
        Party p = this.getPatient(patient);
        if (p != null && interval > 0 && units != null) {
            return this.appointmentRules.getPendingPatientAppointments(p, interval, DateUnits.valueOf(units));
        }
        return Collections.emptyList();
    }

    public Party get(ExpressionContext context) {
        return this.get(context.getContextNodePointer().getValue());
    }

    public Party get(Object object) {
        Party result = null;
        if ((object = FunctionHelper.unwrap((Object)object)) instanceof Party) {
            result = this.getPatient(object);
        } else if (object instanceof Act) {
            Act act = (Act)object;
            IMObjectBean bean = this.service.getBean((IMObject)act);
            result = (Party)bean.getTarget((Collection)act.getParticipations(), Party.class, PATIENT_PARTICIPATION);
        }
        return result;
    }

    public Identity identity(ExpressionContext context, String archetype) {
        return this.identity(context.getContextNodePointer().getValue(), archetype);
    }

    public Identity identity(Object patient, String archetype) {
        Party p = this.getPatient(patient);
        return p != null ? this.patientRules.getEntityIdentity(p, archetype) : null;
    }

    public Iterable<Identity> identities(ExpressionContext context, String archetype) {
        return this.identities(context.getContextNodePointer().getValue(), archetype);
    }

    public Iterable<Identity> identities(Object patient, String archetype) {
        Party p = this.getPatient(patient);
        return p != null ? this.patientRules.getIdentities(p, archetype) : Collections.emptyList();
    }

    public Party location(ExpressionContext context) {
        return this.location(context.getContextNodePointer().getValue());
    }

    public Party location(Object patient) {
        Party p = this.getPatient(patient);
        return p != null ? this.patientRules.getLocation(p) : null;
    }

    public Party location(Object patient, Date date) {
        Party p = this.getPatient(patient);
        if (p != null) {
            return date != null ? this.patientRules.getLocation(p, date, false) : this.location(p);
        }
        return null;
    }

    public Identity microchip(ExpressionContext context) {
        return this.microchip(context.getContextNodePointer().getValue());
    }

    public Identity microchip(Object patient) {
        Party p = this.getPatient(patient);
        return p != null ? this.patientRules.getMicrochip(p) : null;
    }

    public Iterable<Identity> microchips(ExpressionContext context) {
        return this.microchips(context.getContextNodePointer().getValue());
    }

    public Iterable<Identity> microchips(Object patient) {
        return this.identities(patient, "entityIdentity.microchip");
    }

    public Party owner(ExpressionContext context) {
        return this.owner(context.getContextNodePointer().getValue());
    }

    public Party owner(Object patient) {
        Party p = this.getPatient(patient);
        return p != null ? this.patientRules.getOwner(p) : null;
    }

    public Party owner(Object patient, Date date) {
        Party p = this.getPatient(patient);
        if (p != null) {
            return date != null ? this.patientRules.getOwner(p, date, false) : this.owner(p);
        }
        return null;
    }

    public Identity petTag(ExpressionContext context) {
        return this.petTag(context.getContextNodePointer().getValue());
    }

    public Identity petTag(Object patient) {
        return this.identity(patient, "entityIdentity.petTag");
    }

    public Iterable<Identity> petTags(ExpressionContext context) {
        return this.petTags(context.getContextNodePointer().getValue());
    }

    public Iterable<Identity> petTags(Object patient) {
        return this.identities(patient, "entityIdentity.petTag");
    }

    public Identity rabiesTag(ExpressionContext context) {
        return this.rabiesTag(context.getContextNodePointer().getValue());
    }

    public Identity rabiesTag(Object patient) {
        return this.identity(patient, "entityIdentity.rabiesTag");
    }

    public Iterable<Identity> rabiesTags(ExpressionContext context) {
        return this.rabiesTags(context.getContextNodePointer().getValue());
    }

    public Iterable<Identity> rabiesTags(Object patient) {
        return this.identities(patient, "entityIdentity.rabiesTag");
    }

    public Party referral(ExpressionContext context) {
        return this.referral(context.getContextNodePointer().getValue());
    }

    public Party referral(Object patient) {
        return this.referral(patient, false);
    }

    public Party referralByDate(Object patient, Date date) {
        return this.referral(patient, false, date);
    }

    public Party referral(Object patient, boolean practice) {
        return this.referral(patient, practice, null);
    }

    public Party referral(Object object, boolean practice, Date date) {
        Party result = null;
        Party patient = this.getPatient(object);
        if (patient != null) {
            if (date == null) {
                date = new Date();
            }
            Party vet = this.patientRules.getReferralVet(patient, date);
            if (practice) {
                if (vet != null) {
                    result = this.supplierRules.getReferralVetPractice(vet, date);
                }
            } else {
                result = vet;
            }
        }
        return result;
    }

    public Act visit(ExpressionContext context) {
        return this.visit(context.getContextNodePointer().getValue());
    }

    public Act visit(Object patient) {
        Party p = this.getPatient(patient);
        return p != null ? this.recordRules.getEvent(p) : null;
    }

    public BigDecimal weight(ExpressionContext context) {
        return this.weight(context.getContextNodePointer().getValue());
    }

    public BigDecimal weight(Object patient) {
        Party p = this.getPatient(patient);
        return p != null ? this.patientRules.getWeight(p).toKilograms() : BigDecimal.ZERO;
    }

    public BigDecimal weight(Object patient, String units) {
        BigDecimal result = BigDecimal.ZERO;
        Party p = this.getPatient(patient);
        if (p != null) {
            Weight weight = this.patientRules.getWeight(p);
            result = weight.convert(WeightUnits.valueOf((String)units));
        }
        return result;
    }

    public Function getFunction(String namespace, String name, Object[] parameters) {
        if ("referral".equals(name) && parameters != null && parameters.length == 2 && parameters[1] instanceof Date) {
            name = "referralByDate";
        }
        return super.getFunction(namespace, name, parameters);
    }

    private Party getPatient(Object object) {
        return (Party)FunctionHelper.unwrap((Object)object, Party.class, (String)"party.patientpet");
    }
}

