/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.security.loader;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.openvpms.tools.security.loader.RoleData;
import org.openvpms.tools.security.loader.UserData;
import org.xml.sax.ContentHandler;

public class SecurityData
implements Serializable {
    private List<RoleData> roleDataList = new ArrayList<RoleData>();
    private List<UserData> userDataList = new ArrayList<UserData>();

    public void addRoleData(RoleData vRoleData) throws IndexOutOfBoundsException {
        this.roleDataList.add(vRoleData);
    }

    public void addRoleData(int index, RoleData vRoleData) throws IndexOutOfBoundsException {
        this.roleDataList.add(index, vRoleData);
    }

    public void addUserData(UserData vUserData) throws IndexOutOfBoundsException {
        this.userDataList.add(vUserData);
    }

    public void addUserData(int index, UserData vUserData) throws IndexOutOfBoundsException {
        this.userDataList.add(index, vUserData);
    }

    public Enumeration<? extends RoleData> enumerateRoleData() {
        return Collections.enumeration(this.roleDataList);
    }

    public Enumeration<? extends UserData> enumerateUserData() {
        return Collections.enumeration(this.userDataList);
    }

    public RoleData getRoleData(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.roleDataList.size()) {
            throw new IndexOutOfBoundsException("getRoleData: Index value '" + index + "' not in range [0.." + (this.roleDataList.size() - 1) + "]");
        }
        return this.roleDataList.get(index);
    }

    public RoleData[] getRoleData() {
        RoleData[] array = new RoleData[]{};
        return this.roleDataList.toArray(array);
    }

    public int getRoleDataCount() {
        return this.roleDataList.size();
    }

    public UserData getUserData(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.userDataList.size()) {
            throw new IndexOutOfBoundsException("getUserData: Index value '" + index + "' not in range [0.." + (this.userDataList.size() - 1) + "]");
        }
        return this.userDataList.get(index);
    }

    public UserData[] getUserData() {
        UserData[] array = new UserData[]{};
        return this.userDataList.toArray(array);
    }

    public int getUserDataCount() {
        return this.userDataList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends RoleData> iterateRoleData() {
        return this.roleDataList.iterator();
    }

    public Iterator<? extends UserData> iterateUserData() {
        return this.userDataList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllRoleData() {
        this.roleDataList.clear();
    }

    public void removeAllUserData() {
        this.userDataList.clear();
    }

    public boolean removeRoleData(RoleData vRoleData) {
        boolean removed = this.roleDataList.remove(vRoleData);
        return removed;
    }

    public RoleData removeRoleDataAt(int index) {
        RoleData obj = this.roleDataList.remove(index);
        return obj;
    }

    public boolean removeUserData(UserData vUserData) {
        boolean removed = this.userDataList.remove(vUserData);
        return removed;
    }

    public UserData removeUserDataAt(int index) {
        UserData obj = this.userDataList.remove(index);
        return obj;
    }

    public void setRoleData(int index, RoleData vRoleData) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.roleDataList.size()) {
            throw new IndexOutOfBoundsException("setRoleData: Index value '" + index + "' not in range [0.." + (this.roleDataList.size() - 1) + "]");
        }
        this.roleDataList.set(index, vRoleData);
    }

    public void setRoleData(RoleData[] vRoleDataArray) {
        this.roleDataList.clear();
        for (int i = 0; i < vRoleDataArray.length; ++i) {
            this.roleDataList.add(vRoleDataArray[i]);
        }
    }

    public void setUserData(int index, UserData vUserData) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.userDataList.size()) {
            throw new IndexOutOfBoundsException("setUserData: Index value '" + index + "' not in range [0.." + (this.userDataList.size() - 1) + "]");
        }
        this.userDataList.set(index, vUserData);
    }

    public void setUserData(UserData[] vUserDataArray) {
        this.userDataList.clear();
        for (int i = 0; i < vUserDataArray.length; ++i) {
            this.userDataList.add(vUserDataArray[i]);
        }
    }

    public static SecurityData unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SecurityData)Unmarshaller.unmarshal(SecurityData.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

