/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.archetype.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptorReader;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptors;
import org.openvpms.tools.archetype.io.ArchetypeIOHelper;
import org.openvpms.tools.archetype.io.DescriptorLoader;

public class FileSystemLoader
implements DescriptorLoader {
    private final File path;
    private boolean recurse;
    private final ArchetypeDescriptorReader reader;

    public FileSystemLoader(String path, boolean recurse) {
        this.path = new File(path);
        this.recurse = recurse;
        this.reader = new ArchetypeDescriptorReader();
    }

    @Override
    public Map<String, ArchetypeDescriptor> getDescriptors() throws IOException {
        HashMap<String, ArchetypeDescriptor> result = new HashMap<String, ArchetypeDescriptor>();
        if (this.path.isDirectory()) {
            Collection<File> files = ArchetypeIOHelper.getArchetypeFiles(this.path, this.recurse);
            for (File file : files) {
                this.read(file, result);
            }
        } else {
            this.read(this.path, result);
        }
        return result;
    }

    @Override
    public boolean isAll() {
        return this.path.isDirectory();
    }

    @Override
    public String toString() {
        return this.path.toString();
    }

    private void read(File file, Map<String, ArchetypeDescriptor> result) throws FileNotFoundException {
        ArchetypeDescriptors descriptors = this.reader.read(file);
        for (ArchetypeDescriptor descriptor : descriptors.getArchetypeDescriptorsAsArray()) {
            result.put(descriptor.getShortName(), descriptor);
        }
    }
}

