/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.util;

import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;

public class ClassHelper {
    private ClassHelper() {
    }

    public static Class<?> getClass(String name) throws ClassNotFoundException {
        Class result = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                result = ClassUtils.getClass((ClassLoader)classLoader, (String)name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = ClassUtils.getClass((ClassLoader)ClassHelper.class.getClassLoader(), (String)name);
        }
        return result;
    }

    public static void invoke(ClassLoader loader, Runnable runnable) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invoke(ClassLoader loader, Supplier<T> call) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            T t = call.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }
}

