/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.security;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openvpms.component.model.user.User;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class RunAs {
    public static void run(User user, Runnable runnable) {
        SecurityContext context = RunAs.createContext(user);
        DelegatingRunnable delegator = new DelegatingRunnable(context, runnable);
        delegator.run();
    }

    public static <T> T run(User user, Callable<T> callable) throws Exception {
        SecurityContext context = RunAs.createContext(user);
        DelegatingCallable<T> delegator = new DelegatingCallable<T>(context, callable);
        return delegator.call();
    }

    public static <T> T call(User user, Supplier<T> supplier) {
        SecurityContext context = RunAs.createContext(user);
        DelegatingSupplier<T> delegator = new DelegatingSupplier<T>(context, supplier);
        return delegator.get();
    }

    public static <T> Supplier<T> inheritSecurityContext(Supplier<T> supplier) {
        return new DelegatingSupplier<T>(SecurityContextHolder.getContext(), supplier);
    }

    public static <T> Consumer<T> inheritSecurityContext(Consumer<T> consumer) {
        return new DelegatingConsumer<T>(SecurityContextHolder.getContext(), consumer);
    }

    public static Runnable inheritSecurityContext(Runnable runnable) {
        return new DelegatingRunnable(SecurityContextHolder.getContext(), runnable);
    }

    private static SecurityContext createContext(User user) {
        org.openvpms.component.business.domain.im.security.User u = (org.openvpms.component.business.domain.im.security.User)user;
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, (Object)u.getPassword(), u.getAuthorities());
        context.setAuthentication((Authentication)authentication);
        return context;
    }

    private static class DelegatingCallable<T>
    extends Runner
    implements Callable<T> {
        private final Callable<T> callable;

        public DelegatingCallable(SecurityContext context, Callable<T> callable) {
            super(context);
            this.callable = callable;
        }

        @Override
        public T call() throws Exception {
            SecurityContext original = this.init();
            try {
                T t = this.callable.call();
                return t;
            }
            finally {
                this.restore(original);
            }
        }
    }

    private static class DelegatingRunnable
    implements Runnable {
        private final Supplier<Object> supplier;

        public DelegatingRunnable(SecurityContext context, Runnable runnable) {
            this.supplier = new DelegatingSupplier<Object>(context, () -> {
                runnable.run();
                return null;
            });
        }

        @Override
        public void run() {
            this.supplier.get();
        }
    }

    private static class DelegatingConsumer<T>
    extends Runner
    implements Consumer<T> {
        private final Consumer<T> consumer;

        public DelegatingConsumer(SecurityContext context, Consumer<T> consumer) {
            super(context);
            this.consumer = consumer;
        }

        @Override
        public void accept(T t) {
            SecurityContext original = this.init();
            try {
                this.consumer.accept(t);
            }
            finally {
                this.restore(original);
            }
        }
    }

    private static class DelegatingSupplier<T>
    extends Runner
    implements Supplier<T> {
        private final Supplier<T> supplier;

        public DelegatingSupplier(SecurityContext context, Supplier<T> supplier) {
            super(context);
            this.supplier = supplier;
        }

        @Override
        public T get() {
            SecurityContext original = this.init();
            try {
                T t = this.supplier.get();
                return t;
            }
            finally {
                this.restore(original);
            }
        }
    }

    private static abstract class Runner {
        private final SecurityContext context;

        public Runner(SecurityContext context) {
            this.context = context;
        }

        protected SecurityContext init() {
            SecurityContext current = SecurityContextHolder.getContext();
            if (this.context != null) {
                SecurityContextHolder.setContext((SecurityContext)this.context);
            } else {
                SecurityContextHolder.clearContext();
            }
            return current;
        }

        protected void restore(SecurityContext original) {
            SecurityContextHolder.setContext((SecurityContext)original);
        }
    }
}

