/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.ruleengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.rules.admin.RuleExecutionSet;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.openvpms.component.business.service.ruleengine.BaseRuleSource;
import org.openvpms.component.business.service.ruleengine.RuleDescriptor;
import org.openvpms.component.business.service.ruleengine.RuleDescriptors;
import org.openvpms.component.business.service.ruleengine.RuleEngineException;
import org.xml.sax.InputSource;

public class RuleDescriptorRuleSource
extends BaseRuleSource {
    private String descriptorFileName = "rules.xml";
    private Map<String, String> ruleSetNames = new HashMap<String, String>();
    private Map providerProperties;
    private Map rulesetProperties;
    private Map registrationProperties;
    private static final String RULE_SOURCE_MAPPING = "org/openvpms/component/business/service/ruleengine/rule-source-mapping-file.xml";

    protected void registerRuleExecutionSets() throws RuleEngineException {
        try {
            Mapping mapping = new Mapping();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            mapping.loadMapping(new InputSource(new InputStreamReader(loader.getResourceAsStream(RULE_SOURCE_MAPPING))));
            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            Enumeration<URL> urls = loader.getResources(this.descriptorFileName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStreamReader is = new InputStreamReader(url.openStream());
                RuleDescriptors rdescs = (RuleDescriptors)unmarshaller.unmarshal((Reader)is);
                this.addRules(rdescs);
            }
        }
        catch (RuleEngineException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new RuleEngineException(RuleEngineException.ErrorCode.FailedToRegisterRuleExecutionSets, exception);
        }
    }

    public void setProviderProperties(Map providerProperties) {
        this.providerProperties = providerProperties;
    }

    public void setRegistrationProperties(Map registrationProperties) {
        this.registrationProperties = registrationProperties;
    }

    public void setRulesetProperties(Map rulesetProperties) {
        this.rulesetProperties = rulesetProperties;
    }

    public String getDescriptorFileName() {
        return this.descriptorFileName;
    }

    public void setDescriptorFileName(String descriptorFileName) {
        this.descriptorFileName = descriptorFileName;
    }

    @Override
    public boolean hasRuleExecutionSet(String uri) {
        return this.ruleSetNames.containsKey(uri);
    }

    private void addRules(RuleDescriptors descriptors) {
        for (RuleDescriptor rdesc : descriptors.getRuleDescriptors()) {
            try {
                switch (rdesc.getSource()) {
                    case SYSTEM: {
                        this.registerFromFile(rdesc.getPath());
                        break;
                    }
                    case CLASSPATH: {
                        this.registerFromResource(rdesc.getPath());
                    }
                }
            }
            catch (Exception exception) {
                throw new RuleEngineException(RuleEngineException.ErrorCode.FailedToProcessRuleDescriptor, exception, new Object[]{rdesc.getSource(), rdesc.getPath()});
            }
        }
    }

    private void registerFromResource(String path) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream(path);
        if (is == null) {
            throw new RuleEngineException(RuleEngineException.ErrorCode.InvalidFile, path);
        }
        this.registerRuleExecutionSet(is, path);
    }

    private void registerFromFile(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new RuleEngineException(RuleEngineException.ErrorCode.InvalidFile, path);
        }
        this.registerRuleExecutionSet(new FileInputStream(file), path);
    }

    private void registerRuleExecutionSet(InputStream is, String path) {
        String uri = null;
        try {
            RuleExecutionSet ruleExecutionSet = this.ruleAdministrator.getLocalRuleExecutionSetProvider(this.providerProperties).createRuleExecutionSet(is, this.rulesetProperties);
            uri = ruleExecutionSet.getName();
            this.ruleAdministrator.registerRuleExecutionSet(uri, ruleExecutionSet, this.registrationProperties);
            this.ruleSetNames.put(uri, uri);
        }
        catch (Exception exception) {
            throw new RuleEngineException(RuleEngineException.ErrorCode.FailedToRegister, exception, uri, path);
        }
    }
}

