/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.AbstractMonitoringIMObjectCache;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;

public class MonitoringIMObjectCache<T extends IMObject>
extends AbstractMonitoringIMObjectCache<T> {
    private final Map<Reference, T> objects;

    public MonitoringIMObjectCache(IArchetypeService service, String shortName, Class<T> type, boolean prefetch) {
        this(service, shortName, type, new HashMap(), prefetch);
    }

    public MonitoringIMObjectCache(IArchetypeService service, String shortName, Class<T> type, Map<Reference, T> cache, boolean prefetch) {
        super(service, shortName, type);
        this.objects = cache;
        if (prefetch) {
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getObjects() {
        Map<Reference, T> map = this.objects;
        synchronized (map) {
            return new ArrayList<T>(this.objects.values());
        }
    }

    public T getObject(Reference reference) {
        return this.get(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        super.destroy();
        Map<Reference, T> map = this.objects;
        synchronized (map) {
            this.objects.clear();
        }
    }

    @Override
    protected final T addObject(T object) {
        return this.cache(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void removeObject(T object) {
        IMObject removed;
        Map<Reference, T> map = this.objects;
        synchronized (map) {
            removed = (IMObject)this.objects.remove(object.getObjectReference());
        }
        if (removed != null) {
            this.removed(removed);
        }
    }

    protected void added(T object) {
    }

    protected void removed(T object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T get(Reference reference) {
        Object result;
        Map<Reference, T> map = this.objects;
        synchronized (map) {
            result = (IMObject)this.objects.get(reference);
        }
        if (result == null && (result = super.get(reference)) != null) {
            result = this.cache(result);
        }
        return (T)result;
    }

    protected boolean isNewer(T object, T current) {
        return current == object || current.getVersion() < object.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T cache(T object) {
        Object result;
        if (!object.isActive()) {
            this.removeObject(object);
            result = null;
        } else {
            Object added = null;
            Map<Reference, T> map = this.objects;
            synchronized (map) {
                Reference ref = object.getObjectReference();
                IMObject current = (IMObject)this.objects.get(ref);
                if (current == null || this.isNewer(object, current)) {
                    this.objects.put(ref, object);
                    added = object;
                    result = object;
                } else {
                    result = current;
                }
            }
            if (added != null) {
                this.added(object);
            }
        }
        return (T)result;
    }
}

