/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.openvpms.component.business.domain.im.common.Entity;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.common.IMObjectRelationship;
import org.openvpms.component.business.domain.im.common.SequencedPeriodRelationship;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectBean;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;

public class EntityBean
extends IMObjectBean {
    public EntityBean(Entity entity) {
        this(entity, (IArchetypeService)null);
    }

    public EntityBean(Entity entity, IArchetypeService service) {
        super(entity, service);
    }

    public Entity getEntity() {
        return (Entity)this.getObject();
    }

    public org.openvpms.component.business.domain.im.common.EntityRelationship addRelationship(String shortName, Entity target) {
        Entity entity = this.getEntity();
        org.openvpms.component.business.domain.im.common.EntityRelationship r = (org.openvpms.component.business.domain.im.common.EntityRelationship)this.getArchetypeService().create(shortName, org.openvpms.component.business.domain.im.common.EntityRelationship.class);
        r.setSource(entity.getObjectReference());
        r.setTarget(target.getObjectReference());
        entity.addEntityRelationship(r);
        target.addEntityRelationship(r);
        return r;
    }

    public org.openvpms.component.business.domain.im.common.EntityRelationship addNodeRelationship(String name, Entity target) {
        return (org.openvpms.component.business.domain.im.common.EntityRelationship)this.addNodeTarget(name, target);
    }

    @Override
    public IMObjectRelationship addNodeTarget(String name, IMObject target) {
        IMObjectRelationship result = super.addNodeTarget(name, target);
        if (target instanceof Entity && result instanceof org.openvpms.component.business.domain.im.common.EntityRelationship) {
            ((Entity)target).addEntityRelationship((org.openvpms.component.business.domain.im.common.EntityRelationship)result);
        }
        return result;
    }

    public org.openvpms.component.business.domain.im.common.EntityRelationship getRelationship(Entity target) {
        return this.getRelationship(target.getObjectReference());
    }

    public org.openvpms.component.business.domain.im.common.EntityRelationship getRelationship(Reference target) {
        Entity entity = this.getEntity();
        for (Relationship relationship : entity.getEntityRelationships()) {
            if (!target.equals((Object)relationship.getTarget())) continue;
            return (org.openvpms.component.business.domain.im.common.EntityRelationship)relationship;
        }
        return null;
    }

    public List<org.openvpms.component.business.domain.im.common.EntityRelationship> getRelationships(String shortName) {
        return this.getRelationships(shortName, true);
    }

    public List<org.openvpms.component.business.domain.im.common.EntityRelationship> getRelationships(String shortName, boolean active) {
        Set<EntityRelationship> relationships = this.getEntity().getEntityRelationships();
        return this.select(relationships, this.getActiveIsA(active, shortName));
    }

    public void removeRelationship(org.openvpms.component.business.domain.im.common.EntityRelationship relationship) {
        Entity entity = this.getEntity();
        entity.removeEntityRelationship(relationship);
    }

    public Entity getNodeSourceEntity(String node) {
        return (Entity)this.getNodeSourceObject(node);
    }

    public Entity getNodeSourceEntity(String node, boolean active) {
        return (Entity)this.getNodeSourceObject(node, active);
    }

    public Entity getNodeSourceEntity(String node, Predicate predicate) {
        return (Entity)this.getNodeSourceObject(node, predicate);
    }

    public Entity getNodeSourceEntity(String node, Predicate predicate, boolean active) {
        return (Entity)this.getNodeSourceObject(node, predicate, active);
    }

    public Entity getNodeTargetEntity(String node) {
        return (Entity)this.getNodeTargetObject(node);
    }

    public Entity getNodeTargetEntity(String node, boolean active) {
        return (Entity)this.getNodeTargetObject(node, active);
    }

    public Entity getNodeTargetEntity(String node, Predicate predicate) {
        return (Entity)this.getNodeTargetObject(node, predicate);
    }

    public Entity getNodeTargetEntity(String node, Predicate predicate, boolean active) {
        return (Entity)this.getNodeTargetObject(node, predicate, active);
    }

    public Entity getNodeSourceEntity(String node, Date time) {
        return (Entity)this.getNodeSourceObject(node, time);
    }

    public Entity getNodeSourceEntity(String node, Date time, boolean active) {
        return (Entity)this.getNodeSourceObject(node, time, active);
    }

    public Entity getNodeTargetEntity(String node, Date time) {
        return (Entity)this.getNodeTargetObject(node, time);
    }

    public Entity getNodeTargetEntity(String node, Date time, boolean active) {
        return (Entity)this.getNodeTargetObject(node, time, active);
    }

    public List<Entity> getNodeSourceEntities(String node) {
        return this.getNodeSourceObjects(node, Entity.class);
    }

    public List<Entity> getNodeSourceEntities(String node, Date time) {
        return this.getNodeSourceObjects(node, time, Entity.class);
    }

    public List<Entity> getNodeSourceEntities(String node, Date time, boolean active) {
        return this.getNodeSourceObjects(node, time, active, Entity.class);
    }

    public List<Entity> getNodeSourceEntities(String node, Predicate predicate) {
        return this.getNodeSourceObjects(node, predicate, true, Entity.class);
    }

    public List<Entity> getNodeSourceEntities(String node, Predicate predicate, boolean active) {
        return this.getNodeSourceObjects(node, predicate, active, Entity.class);
    }

    public List<Entity> getNodeTargetEntities(String node) {
        return this.getNodeTargetEntities(node, (Comparator<SequencedPeriodRelationship>)null);
    }

    public List<Entity> getNodeTargetEntities(String node, Comparator<SequencedPeriodRelationship> comparator) {
        return this.getNodeTargetObjects(node, Entity.class, comparator);
    }

    public List<Entity> getNodeTargetEntities(String node, Date time) {
        return this.getNodeTargetObjects(node, time, Entity.class);
    }

    public List<Entity> getNodeTargetEntities(String node, Date time, boolean active) {
        return this.getNodeTargetObjects(node, time, active, Entity.class);
    }

    public List<Entity> getNodeTargetEntities(String node, Predicate predicate) {
        return this.getNodeTargetObjects(node, predicate, Entity.class);
    }

    public List<Entity> getNodeTargetEntities(String node, Predicate predicate, boolean active) {
        return this.getNodeTargetObjects(node, predicate, active, Entity.class);
    }

    public List<IMObjectReference> getNodeSourceEntityRefs(String node) {
        return this.getNodeSourceObjectRefs(node);
    }

    public List<IMObjectReference> getNodeSourceEntityRefs(String node, Date time) {
        return this.getNodeSourceObjectRefs(node, time);
    }

    public List<IMObjectReference> getNodeSourceEntityRefs(String node, Predicate predicate) {
        return this.getNodeSourceObjectRefs(node, predicate);
    }

    public List<IMObjectReference> getNodeTargetEntityRefs(String node) {
        return this.getNodeTargetObjectRefs(node);
    }

    public List<IMObjectReference> getNodeTargetEntityRefs(String node, Date time) {
        return this.getNodeTargetObjectRefs(node, time);
    }

    public List<IMObjectReference> getNodeTargetEntityRefs(String node, Predicate predicate) {
        return this.getNodeTargetObjectRefs(node, predicate);
    }

    public List<org.openvpms.component.business.domain.im.common.EntityRelationship> getNodeRelationships(String node) {
        return this.getValues(node, org.openvpms.component.business.domain.im.common.EntityRelationship.class);
    }

    public List<org.openvpms.component.business.domain.im.common.EntityRelationship> getNodeRelationships(String node, Predicate predicate) {
        return this.getValues(node, predicate, org.openvpms.component.business.domain.im.common.EntityRelationship.class);
    }

    public org.openvpms.component.business.domain.im.common.EntityRelationship getNodeRelationship(String node, Predicate predicate) {
        return (org.openvpms.component.business.domain.im.common.EntityRelationship)this.getValue(node, predicate);
    }

    public Entity getSourceEntity(String shortName) {
        return (Entity)this.getSourceObject(this.getEntity().getEntityRelationships(), shortName);
    }

    public Entity getSourceEntity(String shortName, boolean active) {
        return (Entity)this.getSourceObject(this.getEntity().getEntityRelationships(), shortName, active);
    }

    public Entity getSourceEntity(String[] shortNames) {
        return (Entity)this.getSourceObject(this.getEntity().getEntityRelationships(), shortNames);
    }

    public Entity getSourceEntity(String[] shortNames, boolean active) {
        return (Entity)this.getSourceObject(this.getEntity().getEntityRelationships(), shortNames, active);
    }

    public Entity getTargetEntity(String shortName) {
        return (Entity)this.getTargetObject(this.getEntity().getEntityRelationships(), shortName);
    }

    public Entity getTargetEntity(String shortName, boolean active) {
        return (Entity)this.getTargetObject(this.getEntity().getEntityRelationships(), shortName, active);
    }

    public Entity getTargetEntity(String[] shortNames) {
        return (Entity)this.getTargetObject(this.getEntity().getEntityRelationships(), shortNames);
    }

    public Entity getTargetEntity(String[] shortNames, boolean active) {
        return (Entity)this.getTargetObject(this.getEntity().getEntityRelationships(), shortNames, active);
    }

    public Entity getSourceEntity(String shortName, Date time) {
        return (Entity)this.getSourceObject(this.getEntity().getEntityRelationships(), shortName, time);
    }

    public Entity getSourceEntity(String shortName, Date time, boolean active) {
        return (Entity)this.getSourceObject(this.getEntity().getEntityRelationships(), shortName, time, active);
    }

    public Entity getSourceEntity(String[] shortNames, Date time) {
        return (Entity)this.getSourceObject(this.getEntity().getEntityRelationships(), shortNames, time);
    }

    public Entity getSourceEntity(String[] shortNames, Date time, boolean active) {
        return (Entity)this.getSourceObject(this.getEntity().getEntityRelationships(), shortNames, time, active);
    }

    public Entity getTargetEntity(String shortName, Date time) {
        return (Entity)this.getTargetObject(this.getEntity().getEntityRelationships(), shortName, time);
    }

    public Entity getTargetEntity(String shortName, Date time, boolean active) {
        return (Entity)this.getTargetObject(this.getEntity().getEntityRelationships(), shortName, time, active);
    }

    public Entity getTargetEntity(String[] shortNames, Date time) {
        return (Entity)this.getTargetObject(this.getEntity().getEntityRelationships(), shortNames, time);
    }

    public Entity getTargetEntity(String[] shortNames, Date time, boolean active) {
        return (Entity)this.getTargetObject(this.getEntity().getEntityRelationships(), shortNames, time, active);
    }

    public Reference getSourceEntityRef(String shortName) {
        return this.getSourceObjectRef(this.getEntity().getEntityRelationships(), shortName);
    }

    public Reference getSourceEntityRef(String shortName, boolean active) {
        return this.getSourceObjectRef(this.getEntity().getEntityRelationships(), shortName, active);
    }

    public Reference getSourceEntityRef(String[] shortNames, boolean active) {
        return this.getSourceObjectRef(this.getEntity().getEntityRelationships(), shortNames, active);
    }

    public Reference getTargetEntityRef(String shortName) {
        return this.getTargetObjectRef(this.getEntity().getEntityRelationships(), shortName);
    }

    public Reference getTargetEntityRef(String shortName, boolean active) {
        return this.getTargetObjectRef(this.getEntity().getEntityRelationships(), shortName, active);
    }

    public Reference getTargetEntityRef(String[] shortNames, boolean active) {
        return this.getTargetObjectRef(this.getEntity().getEntityRelationships(), shortNames, active);
    }
}

